function sparc_options_string, options
;+
; NAME: sparc_options_string
;
; PURPOSE: convert array of options structures into string for storage
;
; CATEGORY: 
;
; CALLING SEQUENCE: options_code= sparc_options_string( options )
; 
; INPUTS: options, array of options structures defined in sparc_parse_options
;
; KEYWORD PARAMETERS: none
;
; OUTPUTS: string that is in format specified by sparc viewOptions
;
; PROCEDURE: do the opposite of sparc_parse_options
;
; EXAMPLE: 
;    options= sparc_parse_options( options_code )
;    options= sparc_options_widget( options )
;    options_code= sparc_options_string( options )
;
; MODIFICATION HISTORY:
;    written, Apr 4, 2001, jbf, cottagesystems
;-

  inner_separator= '|'
  outer_separator= '~'

  option1= { name:'', $
             description:'', $
             type:'', $
             default:'', $
             list_value:strarr(32), $
             list_label:strarr(32), $
             widget_id:lonarr(4) $  ; convenience for other routines
           }
  
  options_str= strarr(n_elements(options))

  for is= 0,n_elements(options)-1 do begin

      options_str[is]= $
        options[is].name + inner_separator + $
        options[is].description + inner_separator + $
        options[is].type + inner_separator + $
        options[is].default + inner_separator 

      if options[is].type eq 'l' or options[is].type eq 'a' then begin
          idx=0
          r= where( options[is].list_value[*] ne '', nr ) 
          for ir= 0,nr-1 do begin
              idx= r[ir]
              options_str[is]= options_str[is] + inner_separator + $
                options[is].list_value[idx] + inner_separator + $
                options[is].list_label[idx]
          endfor
          options_str[is]= options_str[is] + inner_separator + inner_separator
      endif

  endfor ;is

  options_code= ''
  for i=0,n_elements(options_str)-1 do begin
      options_code= options_code + options_str[i] + outer_separator
  endfor

  return, options_code

end


