function sparc_options_url, options
;+
; NAME: sparc_options_url
;
; PURPOSE: convert array of options structures into string for the
;    image data request URL. 
;
; CATEGORY: 
;
; CALLING SEQUENCE: options_url= sparc_options_url( options )
; 
; INPUTS: options, array of options structures defined in sparc_parse_options
;
; KEYWORD PARAMETERS: none
;
; OUTPUTS: string that is in format for the image request
;
; PROCEDURE: 
;
; EXAMPLE: 
;    options= sparc_parse_options( options_code )
;    options= sparc_options_widget( options )
;    options_url= sparc_options_url( options )
;
; MODIFICATION HISTORY:
;    written, Apr 4, 2001, jbf, cottagesystems
;-

  options_url= options[0].name + '=' + options[0].default

  for is= 1,n_elements(options)-1 do begin
      
      options_url= options_url + '&' + $
        options[is].name + '=' + options[is].default 

  endfor

  return, options_url

end


