pro sparc_options_widget_handle, options, i, event

  case strmid(options[i].type,0,1) of
      'g': begin
            ; papco sets this value
      end
      
      'l': begin
          options[i].default= options[i].list_value[event.index]
      end
      
      'r': begin
          type= strlowcase(strmid(options[i].type,1,1))
          if type ne 't' then begin
              widget_control, options[i].widget_id[0], get_value=r0
              widget_control, options[i].widget_id[1], get_value=r1
              options[i].default= strtrim(r0,2) + ',' + strtrim(r1,2)
          endif
      end
      
      'i': begin
          widget_control, options[i].widget_id[0], get_value=x
          options[i].default= strtrim(x,2)
      end
      
      'f': begin
          widget_control, options[i].widget_id[0], get_value=x
          options[i].default= strtrim(x,2)
      end
      
      's': begin
          widget_control, options[i].widget_id[0], get_value=x
          options[i].default= x
      end
      
      'b': begin
          options[i].default= ( [ 'false', 'true' ] ) (event.select)
      end
      
      'a': begin
          s= str_sep(options[i].default,',')
          structure_name= tag_names(event,/structure_name)
          if (structure_name eq 'WIDGET_BUTTON') then begin
              log= ( [ 'false', 'true' ] ) (event.select)
              s[3]= log
          endif else if (structure_name eq 'WIDGET_DROPLIST' ) then begin
              s[0]= options[i].list_value[event.index]
          endif else begin
              widget_control, options[i].widget_id[1], get_value=r1
              widget_control, options[i].widget_id[2], get_value=r2
              s[1]= strtrim(r1,2)
              s[2]= strtrim(r2,2)
          endelse
          options[i].default= $
            s[0]+','+s[1]+','+s[2]+','+s[3]
      end
      
      'd': begin              
          message, 'not implemented: d', /cont
      end
          
      'x': begin
          message, 'not implemented: x', /cont              
      end
      
      else: begin
          message, 'not recognized: '+options[i].type, /cont
      end

  endcase
      
end

pro sparc_options_widget_event, event

  common sparc_options_widget_common, options

  widget_control, event.id, get_uvalue=uval
  
  if n_elements( uval ) ne 0 then begin

      s= str_sep( uval, ':' )
      uval= s[0]
      
      if n_elements(s) eq 2 then begin
          arg= strtrim(s[1],2)
      endif
      
      case uval of
          'quit': widget_control, event.top, /destroy
          'option': begin
              idx= long(arg)
              sparc_options_widget_handle, options, idx, event
          end
          else: 
      endcase
  endif

end      

function sparc_options_widget, options_in, group=group
  
  modal= n_elements(group) ne 0
  options_base= widget_base( title='Options', modal=modal, $
                             group=group, /column )
  
  common sparc_options_widget_common, options
  options= options_in

  for i=0,n_elements(options)-1 do begin
      uval= 'option: '+strtrim(i,2)
      case strmid(options[i].type,0,1) of
          'g': begin
            ; papco sets this value
          end

          'l': begin
              x= widget_label( options_base, /align_left, $
                               value=options[i].description )
              base= widget_base( options_base, /exclusive, /column )
              x= where( options[i].list_value ne '', count )
              slist= options[i].list_label[0:(count-1)]
              options[i].widget_id[0]= $
                widget_droplist( options_base, value=slist, $
                                 uvalue=uval )
              r= where( options[i].list_value eq options[i].default )
              if r[0] ne -1 then begin
                  widget_control, options[i].widget_id[0], $
                    set_droplist_select=r[0]
              endif
          end

          'r': begin
              type= strlowcase(strmid(options[i].type,1,1))
              if type ne 't' then begin
                  x= widget_label( options_base, /align_left, $
                                   value= options[i].description )
                  base= widget_base( options_base, /row )
                  case type of
                      'i': type_opt= { integer:1 }
                      'f': type_opt= { float:1 }
                      else: ; ????
                  endcase
                  s= str_sep( options[i].default, ',' )
                  options[i].widget_id[0]= $
                    cw_field( base, title='', xsize=6, $
                              value=s[0], _extra=type_opt, $
                              uvalue=uval, /all_events )
                  options[i].widget_id[1]= $
                    cw_field( base, title='', xsize=6, $
                              value=s[1], _extra=type_opt, $
                              uvalue=uval, /all_events )
              endif
          end

          'i': begin
              x= widget_label( options_base, /align_left, $
                               value= options[i].description )
              options[i].widget_id[0]= $
                cw_field( options_base, title='', xsize=6, $
                          value= long(options[i].default), $
                          /long, $
                          uvalue= uval, /all_events )
          end
          
          'f': begin
              x= widget_label( options_base, /align_left, $
                               value= options[i].description )
              options[i].widget_id[0]= $
                cw_field( options_base, title='', xsize=6, $
                          value= long(options[i].default), $
                          /float, $
                          uvalue=uval, /all_events )
          end

          's': begin
              x= widget_label( options_base, /align_left, $
                               value= options[i].description )
              options[i].widget_id[0]= $
                cw_field( options_base, title='', value= options[i].default, $
                          uvalue=uval, /all_events )
          end

          'b': begin
              base= widget_base( options_base, /nonexclusive )
              options[i].widget_id[0]= $
                widget_button( base, value= options[i].description, $
                               uvalue=uval )
              r= where( options[i].default eq $
                        [ 'false', 'true' ] )
              widget_control, options[i].widget_id[0], set_button= r[0]
          end

          'a': begin
              x= widget_label( options_base, /align_left, $
                               value= options[i].description )

              s= str_sep( options[i].default, ',' )

              base_a= widget_base( options_base, /column )
              
              x= where( options[i].list_value ne '', count )
              if count gt 0 then begin
                  slist= options[i].list_label[0:(count-1)]
                  options[i].widget_id[0]= $
                    widget_droplist( base_a, value=slist, $
                                     uvalue=uval )
                  idx= (where( s[0] eq options[i].list_value ))[0]
                  widget_control, options[i].widget_id[0], $
                    set_droplist_select= idx
              endif

              base= widget_base( base_a, /row )
              options[i].widget_id[1]= cw_field( base, title='', xsize=6, $
                                                 value=s[1], /float, $
                                                 uvalue=uval, /all_events )
              options[i].widget_id[2]= cw_field( base, title='', xsize=6, $
                                                 value=s[2], /float, $
                                                 uvalue=uval, /all_events )
              base= widget_base( base_a, /column, /nonexclusive )
              options[i].widget_id[3]= widget_button( base, value='Log', $
                                                      uvalue=uval)
              r= where( s[3] eq [ 'false', 'true' ] )
              widget_control, options[i].widget_id[3], set_button= r[0]
          end

          'd': begin              
              message, 'not implemented: d', /cont
          end
          
          'x': begin
              message, 'not implemented: x', /cont              
          end

          else: begin
              message, 'not recognized: '+options[i].type, /cont
          end
      endcase
  endfor

  x= widget_button( options_base, value='Close', uvalue='quit' )

  widget_control, options_base, /realize
  
  xmanager, 'sparc_options_widget', options_base

  return, options

end

pro testit
  
  dc= 'sparc-dc2.si.umich.edu/sparc/DataCenter'
  name= 'MillstoneHill.ISRadar'
  
  view= sparc_get_default_view( dc, name, status=status )

  if status.code ne 0 then begin
      sparc_abend, status, /text
      return
  endif
  
  options_code= sparc_get_options( dc, name, view )

  base= widget_base( title='Options', /column )

  options= sparc_parse_options(options_code)
  options_code2= sparc_options_string(options)

  options_new= sparc_options_widget( options )

  stop

end
      
