function sparc_parse_options, options_code

  inner_separator= '|'
  outer_separator= '~'

  type_list='l'

  option1= { name:'', $
             description:'', $
             type:'', $
             default:'', $
             list_value:strarr(32), $
             list_label:strarr(32), $
             widget_id:lonarr(4) $  ; convenience for other routines
           }
  
  options_str= str_sep( options_code, outer_separator )
  r= where( strtrim( options_str, 2 ) ne '' )
  options_str= options_str[r]
  
  options= replicate( option1, n_elements(options_str) )

  for is= 0,n_elements(options_str)-1 do begin

      s= str_sep( options_str[is], inner_separator )
      
      options[is].name= s[0]
      options[is].description= s[1]
      options[is].type= strlowcase(s[2])
      options[is].default= s[3]

      if options[is].type eq 'l' or options[is].type eq 'a' then begin
          idx=0
          for ii=5,n_elements(s)-1,2 do begin
              if idx ge 32 then begin
                  message, 'list option too long for data structure.', /cont
                  message, 'dropping remaining list elements.', /cont
              endif else begin
                  options[is].list_value[idx]= s[ii]
                  options[is].list_label[idx]= s[ii+1]
                  idx= idx+1
              endelse
          endfor
      endif

  endfor

  return, options

end


