;******************************************************************************
;* file sparc_slice.pro
;*
;* this file contains the routines needed to enable the extra mouse features
;* provided for in papco. 
;*
;* Currently possible:
;*
;*    mouse zooms                        no routine here, in papco main
;*    mouse vertical slice               routine here
;*    mouse views slice (polar)          specialty slice - no routine here
;*    mouse views ephemeris              under development (POLAR only)
;*    mouse accesses level zero          routine here
;*    mouse writes paneldata             routine here
;*    mouse horizontal slice             routine here
;* 
;* Here the procedure names must again adhere to a strict naming convention so 
;* that they can be automatically called when needed.
;*
;* The slice types supported by these routines must be ENABLED by the user, so 
;* that papco can call them. This is done by setting the value of 
;* slice_type in draw_sparc.pro (contained in papcoadd_sparc.pro).
;* slice_type is defined in the following way:
;*
;*   slice_type:   Selects which slices are supported and for which slice
;*                 routines have been written.
;*                 This is an integer logical with 16 swittches. Currently
;*                 there are 5 papco slices. You may extend this by
;*                 further USER slices up to a total of 16 slices.
;*                     0 = disable all slices
;*                     1 = papco Zoom                 (2^0)
;*                     2 = papco View Slice           (2^1)
;*                     4 = papco Access level Zero    (2^2)
;*                     8 = papco Write Paneldata      (2^3)
;*                    16 = papco Hair Cursor          (2^4)
;*                    32 = papco horizontal Slice     (2^5)    
;*                    64 = USER slice A or not used   (2^6)
;*                   128 = USER slice B or not used   (2^7)
;*                    "     "     "   "  "  "    "      "    
;*                 32768 = USER slice Z or not used  (2^15)
;*                        
;*   You can support more than one type of slice by arithmetically adding the
;*   options, eg slice_type=1+4  support Zoom and Level Zero
;*
;* The "papco Zoom" function uses the mouse to define an area of a panel. 
;* Dragging the mouse with the left button pressed marks out a shaded rectangle
;* in the panel. The time range and y-range of the rectangle are read out in a
;* window and the user has the option of adopting these new ranges. The papco 
;* main common block for time (common mjdt, mjdt_start, mjdt_end) and y-range
;* (common yscale, yscl) are updated accordingly. Provided within PAPCO.
;*
;* The "papco Views Slice" function uses the time returned by papco and the
;* get_data_call specified for the sparc to read the data and to draw a 
;* slice at the clicked position. This is commonly used in spectra color plots 
;* to draw a spectrum at that time, or a pitch angle distribution etc, or to
;* call up any other plot at that time as specified by the user. 
;* -> user defined interface routine needed, template included here
;*
;* The "papco Accesses level Zero" uses the time passed and calls up another
;* widget application to read and work with level zero data. This application
;* must be entirely independent of papco and is only called from papco via
;* a mouse click in the panel required for the time required.
;* -> user defined interface routine needed, template included here
;*
;* The "papco Write Paneldata" function allows the user to read off data from 
;* panels using the mouse and to write that data to a file. This is a papco
;* supplied utility slice which by default only writes the time and y-value of
;* the mouse-click to file. The user can however interface his own routine to
;* add auxiliary data to the string written to file.
;* The output file is written in ASCII and has the same format as the .event
;* files used by the event times utility module. The files can thus be used
;* in the events time module to mark events on panels.
;* -> user defined interface routine possible, template included here
;*
;* The "papco Hair Cursor" function draws a large hair cursor and outputs
;* x,y,and z corrdinates onto the plot.  Provided within PAPCO.
;*
;* If your new data contains several sub-data types, one slice and/or levelzero
;* routine has to be provided for each type, since in general they would do
;* different things. See 
;* $papco_modules\crres_meb\papco_interface\crres_slices.pro  
;* for such an example.
;*
;*      PRO DrawSlice_sparc, panelNr, seconds, yValue
;*        -> Draw a slice for sparc
;*
;*      PRO levelzero_sparc, seconds, yValue
;*        -> This procedure calls the widget for levelzero data access 
;*           for this plottype.
;*
;*      PRO WriteSlice_sparc, panelNr, seconds, yValue
;*        -> This procedure calls the widget for writing panelinfo data to file
;*    
;* MODIFICATION HISTORY:       
;*      December 1995, written by R.Friedel at Goddard
;*      modified may 1997, Reiner Friedel
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO DrawSlice_sparc, panelNr, seconds, yValue
;* 
;* DESCRIPTION:  
;*      Draw a slice for sparc
;*      calling a separate window for the plot.
;*      slice_type in draw_sparc must be set to +2 to enable this feature.
;*
;* INPUTS:       
;*      panelNr     an integer, the number of the panel for which the slice 
;*                  is to be drawn
;*      seconds     time of mouse click, a float
;*      yvalue      y-value of mouse click, a float
;*      
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      called by papco_DrawSLice (in $papco_PATH/papco_cursor.pro)
;*
;* MODIFICATION HISTORY:       
;*      December 1995, written by R.Friedel at Goddard
;******************************************************************************
PRO vert_slice_sparc_image, panelNr, seconds, yValue, readdata=readdata

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData

   WIDGET_CONTROL,/HOURGLASS

   plotInfo=widgetData.plotsDrawn(panelNr)
   
   dataCenter= plotInfo.soptions[0]
   name= plotInfo.soptions[1]

   ct_time= seconds / 86400.D
   time_mjdt=papco_cursor_time(seconds,panelNr,/mjdt)
      
   stop

; set the panel window for the slice to full window

   !p.position=[0.1,0.1,0.9,0.9]

   info1='Data Center: '+dataCenter
   info2='Time: '+ct_time_string(ct_time)

   WIDGET_CONTROL, sliceWidgetData.lbl_slice1, SET_VALUE=info1
   WIDGET_CONTROL, sliceWidgetData.lbl_slice2, SET_VALUE=info2

END
