pro p_sparc_image, dataCenter, name, view, ct_start, ct_end, $
                   draw_timeaxis=draw_timeaxis, $
                   options=options, $
                   SUBTABLE=SUBTABLE, $
                   _EXTRA=extra_par

  anti_alias= getenv('SPARC_ANTI_ALIAS' ) eq '1'  and  !d.name ne 'PS'

  ll= fix( convert_coord( !p.position[0:1], /normal, /to_device ) )
  ur= fix( convert_coord( !p.position[2:3], /normal, /to_device ) )

  if !d.name eq 'PS' then begin      
      ps_resolution= 150 / 2.54 ; desired resolution in pixels/cm
      ps_fac=  ps_resolution / !d.x_px_cm  ; takes native to desired
      xsize= ceil(( ur[0]-ll[0]) * ps_fac )
      ysize= ceil(( ur[1]-ll[1]) * ps_fac )
      tonormx= 1. / ( !d.x_size * ps_fac )
      tonormy= 1. / ( !d.y_size * ps_fac )
  endif else begin
      xsize= ceil(ur[0]-ll[0])
      ysize= ceil(ur[1]-ll[1])
      tonormx= 1./!d.x_size
      tonormy= 1./!d.y_size
      ps_fac= 1.0
  endelse

  if anti_alias then begin
      message, 'Getting high resolution image from SPARC for anti-aliasing', $
        /cont
      aa_fact=2
  endif else aa_fact=1

  image= sparc_get_view_image( dataCenter, $
                               name, $
                               view, $
                               ct_start, $
                               ct_end, $
                               size=[xsize,ysize]*aa_fact, $
                               status=status, $
                               options=options )
  
  if status.code ne 0 then begin
      sparc_abend, status
      return
  endif

  if anti_alias then begin
      image= rebin( image, 4, xsize, ysize )
        ; if opacity is non-zero, then make opaque.  50% opacity is
        ;   difficult to read and does not benefit the visualization.

      opacity= image(3,*,*)
      r= where( opacity gt 0 )
      if r[0] ne -1 then opacity[r]= 255
      image(3,*,*)= opacity 
  endif

  if status.code eq 0 then begin
      sparc_tv, image, $
        ll[0]*ps_fac*tonormx, ll[1]*ps_fac*tonormy, /norm,  /true, $
        xsize=xsize*tonormx, ysize=ysize*tonormy
  endif else begin
      xyouts, 0, 0.5, status.message
  endelse

  xsize_yaxis= floor(ll[0] * ps_fac)

  image_yaxis= sparc_get_view_image( dataCenter, $
                                     name, $
                                     view, $
                                     ct_start, $
                                     ct_end, $
                                     size=[xsize_yaxis,ysize], $
                                     /yaxis, $
                                     status=status, $
                                     options=options )

  if status.code eq 0 then begin
      sparc_tv, image_yaxis, $
        (ll[0]*ps_fac-xsize_yaxis)*tonormx, $
        (ll[1]*ps_fac)*tonormy, /normal,  /true, $
        xsize=xsize_yaxis*tonormx, ysize=ysize*tonormy
  endif else begin
      sparc_abend, status
      return
  endelse

  xsize_cbar= floor((!d.x_size-ur[0])*ps_fac)
  ysize_cbar= ysize - long( !d.y_ch_size*ps_fac * 1.2 )
  image_cbar= sparc_get_view_image( dataCenter, $
                                    name, $
                                    view, $
                                    ct_start, $
                                    ct_end, $
                                    size=[xsize_cbar,ysize_cbar], $
                                    /colorbar, $
                                    status=status, $
                                    options=options )
  
  if status.code eq 0 then begin
      sparc_tv, image_cbar, ur[0]*ps_fac*tonormx, ll[1]*ps_fac*tonormy, $
        /normal,  /true, $
        xsize=xsize_cbar*tonormx, ysize=ysize_cbar*tonormy
  endif else begin
      sparc_abend, status
      return
  endelse
  
  plot, [0,1], /nodata, xstyle=5, ystyle=5, $
    xrange=[0,(ct_end-ct_start)*86400]  
  
  xyouts, !p.position[2], $
    !p.position[3]-float(!d.y_ch_size)/!d.y_size, /normal, $
    name, color=1

  if keyword_set(draw_timeaxis) then begin
      ysize_time= ceil(ll[1]*ps_fac)
      image_timeaxis= $
        sparc_get_view_image( 'sparc-dc3.si.umich.edu/sparc/DataCenter', $
                              'GMT', $
                              'timeaxis', $
                              ct_start, ct_end, $
                              /timeaxis, $
                              size= [xsize,ysize_time], status=status )
      
      if status.code eq 0 then begin
          sparc_tv, image_timeaxis, $
            ll[0]*ps_fac*tonormx, (ll[1]*ps_fac-ysize_time)*tonormy, $
            xsize=xsize*tonormx, ysize=ysize_time*tonormy, $
            /normal, /true
      endif else begin
          sparc_abend, status
      endelse
      
  endif
  
end 






