;+
; NAME: sparc_tv
;
; PURPOSE: wrap tv procedure, supporting transparency, also 
;    switch properly to ps device.
;
; CATEGORY: plotting
;
; CALLING SEQUENCE: sparc_tv, image, [x, y]
; 
; INPUTS: 
;   image  bytarr[4,n,m]   0:2 are the RGB channels, 
;                          3 is the opacity channel.  0=transparent, 255=opaque
;                            This is only implemented to put the
;                            background color where opacity=0.  (Until
;                            there is a need for a more sophistocated version.)
;
;
;
; OPTIONAL INPUTS:
;   x, y   position of the image
;
; KEYWORD PARAMETERS:
;   /device   position is in device coordinates.
;   /normal   position is in normal coordinates.
;
; OUTPUTS:
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;    not thoroughly tested and error-prone.
;
; PROCEDURE:
;
; EXAMPLE:
;
; MODIFICATION HISTORY:
;    Written, Mar 7, 2001, jbf, cottagesystems.
;-

pro sparc_tv, image_in, x, y, $
              device=device, data=data, normal=normal, _extra=e, $
              xsize=xsize, ysize=ysize, true=true_in

  image= image_in[0:2,*,*]
  alpha= image_in[3,*,*]/255.
  true= true_in

  true_color= getenv( 'SPARC_8BIT_COLOR' ) ne '1' or $
    !d.name eq 'PS'

  if min(alpha) lt 1. then begin
      if !d.name eq 'PS' then begin
          backcolor= [255,255,255]
      endif else begin
          tvlct, r, g, b, /get
          backcolor= [ r[!p.background], g[!p.background], b[!p.background] ]
      endelse
      
      image[0,*,*]= image[0,*,*] * alpha + backcolor[0] * (1.-alpha)  
      image[1,*,*]= image[1,*,*] * alpha + backcolor[1] * (1.-alpha)  
      image[2,*,*]= image[2,*,*] * alpha + backcolor[2] * (1.-alpha) 

  endif

  if true_color eq 0 then begin
      common papco_color, papco_color, r_papco, g_papco, b_papco
      cindex= where( papco_color(*,2) eq 1 ) ; search the active vector

      papco_occupy_subtable, 2
      papco_occupy_subtable, 3
      
      cr1= PAPCO_get_Colorindices( 2 )
      cr2= PAPCO_get_Colorindices( 3 )
      
      color_range= [ cr1[0], cr2[1] ]
      
      cube_size= floor( ( color_range[1] - color_range[0] + 1 ) ^ (1/3.) )
      image8= color_quan( image[0,*,*], image[1,*,*], image[2,*,*], $
                          cube=cube_size, R, G, B )

      COMMON papco_color, papco_color, r_papco, g_papco, b_papco

      tvlct, /get, R1, G1, B1
      
      R1(color_range(0):(color_range(0)+n_elements(R)-1))= R
      G1(color_range(0):(color_range(0)+n_elements(G)-1))= G
      B1(color_range(0):(color_range(0)+n_elements(B)-1))= B

      tvlct, R1, G1,B1

      r_papco= r1
      g_papco= g1
      b_papco= b1

      image= image8 + color_range(0)
      true= 0

  endif


  if !d.name eq 'PS' then begin

      if keyword_set(normal) then begin
          xnorm= x
          ynorm= y
      endif else if keyword_set(data) then begin
          r= convert_coord( [x,y], /data, /to_norm )
          xnorm=r[0]
          ynorm=r[1]
      endif else begin
          xnorm= x / float(!d.x_size)
          ynorm= y / float(!d.y_size)
      endelse

      tvlct, r0, g0, b0, /get

      tvlct, indgen(256), indgen(256), indgen(256) ; see PS true color images

      tv, image, xnorm, ynorm, /normal, xsize=xsize, ysize=ysize, _extra=e, $
        true=1

      tvlct, r0, g0, b0 ;  restore color table

  endif else if !d.name eq 'Z' then begin

      tv, image8, x, y, _extra=e, $
        device=device, normal=normal, data=data, $
        xsize=xsize, ysize=ysize, true=true

  endif else begin

      tv, image, x, y, _extra=e, $
        device=device, normal=normal, data=data, $
        xsize=xsize, ysize=ysize, true=true

  endelse

end

