pro p_step_mag,panel,type

;inputs panel = panel vector
;       type  = select which component: 1 - H component
;                                       2 - Z component
;                                       3 - X component
;                                       4 - Y component
;                                       5 - F component
;                                       6 - Declination


common step_mag, time,h,z,x,y,f,d
common info ,iday,imonth,iyear,station
common time, xut1,xut2
common yscale, yscl

panelset,panel   ;setup viewport

monarr=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
labarr=['(a)','(b)','(c)','(d)','(e)','(f)','(g)','(h)','(i)','(j)','(k)']

cmonth=monarr(imonth-1)

if (panel(1) eq 1) then begin
  ctit='STEP Project 6.4        ' + string (iday,cmonth,iyear, "(i2.2,a4,i5)") + '     Magnetic Field     groundbased'
endif else begin
  ctit=' '
endelse

!x.ticks=10
yt='nT'

case type of
  1:begin
      yray=h
      ylim,time,yray,yst,yen
      ctit2='B!DH!N'
      lsty=0
    end
  2:begin
      yray=z
      ylim,time,yray,yst,yen
      ctit2='B!DZ!N'
      lsty=0
    end
  3:begin
      yray=x
      ylim,time,yray,yst,yen
      ctit2='B!DX!N'
      lsty=0
    end
  4:begin
      yray=y
      ylim,time,yray,yst,yen
      ctit2='B!DY!N'
      lsty=0
    end
  5:begin
      yray=f
      ylim,time,yray,yst,yen
      ctit2='B!DF!N'
      lsty=0
    end
  6:begin
      yray=d
      ylim,time,yray,yst,yen
      ctit2='Declination'
      yt='tenth min'
      lsty=0
    end
endcase

ctit2=ctit2+' ('+strupcase(station)+')!C!C'+labarr(panel(1)-panel(0)-1)

if (yscl(panel(0),0) eq 1) then begin
   yst=yscl(panel(0),1)
   yen=yscl(panel(0),2)
endif else begin
   yscl(panel(0),1)=yst
   yscl(panel(0),2)=yen
endelse

if (panel(0) eq 0) then begin

plot,time,yray,xtickformat='timeticks',xstyle=3,ystyle=1,yrange=[yst,yen],xrange=[xut1,xut2],ytitle=yt,title=ctit,linestyle=lsty,/noerase,ticklen=-0.015,color=1 
oplot,[xut1,xut2],[0.0,0.0],linestyle=2,color=1
 
endif else begin

plot,time,yray,xtickformat='noticks',xstyle=3,ystyle=1,yrange=[yst,yen],xrange=[xut1,xut2],ytitle=yt,linestyle=lsty,/noerase,ticklen=-0.015,color=1 
oplot,[xut1,xut2],[0.0,0.0],linestyle=2,color=1

endelse

if (panel(1) ne 1) then xyouts,!p.position(2)+0.02,!p.position(3)-0.0335, ctit2,/normal,color=1

if ((panel(1) eq panel(0)+panel(2))  and (panel(1) ne 1)) then xyouts, !p.position(0)+0.01,!p.position(3)+0.02,'STEP Project 6.4   ' + string (iday,cmonth,iyear, "(i2.2,a4,i5)") + '  Magnetic Field  groundbased', /normal,charsize=1.5,color=1

end
