pro r_step_mag,region,obs,year,month,day

;inputs region = AZ, PC, ML, LL, EQ
;       obs    = three letter station code
;       year,month,day


   common step_mag, time,h,z,x,y,f,d
   common info, iday,imonth,iyear,station
   common time, xut1,xut2
   common get_error, get_err_no, get_err_msg

   get_err_no=0
   get_err_msg='STEP - data successfully read'

   da=0 & mo=0 & yr=0.0 & iyear=year & iday=day & imonth=month & station=obs
   ndp=0l & long=0l & yr=0 & mo=0 & da=0 & e='' & hr=0 & ob=''
   org='' & blank=''
   inst=replicate(32B,400)
   onehour=lonarr(60)
   h=lonarr(1440)
   z=lonarr(1440)
   x=lonarr(1440)
   y=lonarr(1440)
   f=lonarr(1440)
   d=lonarr(1440)
   time=fltarr(1440)

; check env. variable pointing to data directory
  if not (papco_check_data_env('STEP_MAG_CDROM', PATH=source)) then return

; search in three places for file: in path source, source/cdrom1 and
; source/cdrom2. 
  fln=string(obs,year,month,format='(a3,i2.2,i2.2)')
  fln2 = findfile(source+region+'/'+fln+'*', count = c)
  IF c EQ 0 THEN fln2 = findfile(source+'cdrom1/'+region+'/'+fln+'*',count = c)
  IF c EQ 0 THEN fln2 = findfile(source+'cdrom2/'+region+'/'+fln+'*',count = c)

  IF c NE 0 THEN message, 'File found: '+fln2(0), /cont ELSE $
    message,  fln(0)+'  :  not found.', /cont

   openr, f_Unit, fln2(0), /GET_LUN, ERROR=ERR
   IF err NE 0 THEN BEGIN
      get_err_no=2
      get_err_msg=!ERR_STRING
      RETURN
   ENDIF

   i=-1
   while not eof(f_Unit) do begin
      i=i+1
      readu,f_Unit,inst
      inst=string(inst)
      reads,inst, $
        format='(2(i6),3(i2),a1,i2,a3,a1,a9,60(i6))',   $
        ndp,long,yr,mo,da,e,hr,ob,org,blank,onehour

      on_ioerror,onwards

      if da eq day then begin
         case e of
            'H' : h(hr*60+0:hr*60+59)=onehour
            'Z' : z(hr*60+0:hr*60+59)=onehour
            'X' : x(hr*60+0:hr*60+59)=onehour
            'Y' : y(hr*60+0:hr*60+59)=onehour
            'F' : f(hr*60+0:hr*60+59)=onehour
            'D' : d(hr*60+0:hr*60+59)=onehour
         endcase
      endif

onwards:
      if da eq day+1 then  goto,out
   endwhile

out:
   close,f_Unit
   FREE_LUN, f_Unit

   for i=0,1439 do time(i)=30.0+i*60.0

   if xut1 eq xut2 then begin
      xut1=time(0)
      xut2=time(1439)
   endif

   return

end
