pro r_step_mag2,region,obs

;reads magdata for more than one day
;inputs region = AZ, PC, ML, LL, EQ
;       obs    = three letter station code
; time is set via common block variables xut1,xut2  

   common step_mag, time,h,z,x,y,f,d
   common info, iday,imonth,iyear,station
   common time, xut1,xut2       ;(time in seconds since 1990)

   common get_error, get_err_no, get_err_msg

   get_err_no=0
   get_err_msg='STEP - data successfully read'

   mon=[31,28,31,30,31,30,31,31,30,31,30,31]

   if 1 eq 0 then begin
      if xut1 gt 31536000l then begin
         y1=91
         d1= long (xut1-31536000l) / 84600l + 1
      endif else begin
         y1=90
         d1= long (xut1 / 86400l) + 1
      endelse   

      doy=d1
      i=0
      while doy gt 0 do begin
         doy=doy-mon(i)
         i=i+1
      endwhile
      day1=doy+mon(i-1)
      month1=i
;      print,d1,day1,month1,y1

      if xut2 gt 31536000l then begin
         y2=91
         d2= long (xut2-31536000l) / 84600l
      endif else begin
         y2=90
         d2= long (xut2 / 86400l) + 1
      endelse   

      doy=d2
      i=0
      while doy gt 0 do begin
         doy=doy-mon(i)
         i=i+1
      endwhile
      day2=doy+mon(i-1)
      month2=i
   endif 

;   print,d2,day2,month2,y2

   dummy=convert_t90_to_tzero(xut1, d1, y1)
   dummy=convert_t90_to_tzero(xut2, d2, y2)
   
   for i=d1,d2 do begin

      doy=i
      j=0
      while doy gt 0 do begin
         doy=doy-mon(j) & j=j+1
      endwhile
      day=doy+mon(j-1)
      month=j
      year=y1
;  print,i,day,month,year

      r_step_mag,region,obs,year,month,day
      IF get_err_NO NE 0 THEN return

      if i eq d1 then begin
         timeall=time+long(i-1)*86400l+ long(y1-90)*31536000l
         hall=h
         zall=z
         xall=x
         yall=y
         fall=f
         dall=d
      endif else begin
         time=time+long(i-1)*86400l+ long(y1-90)*31536000l
         timeall=[timeall,time]
         hall=[hall,h]
         zall=[zall,z]
         xall=[xall,x]
         yall=[yall,y]
         fall=[fall,f]
         dall=[dall,d]
      endelse
   endfor

   time=timeall
   h=hall
   z=zall
   x=xall
   y=yall
   f=fall
   d=dall

;set bad / missing data to zero
   index=where(h eq 99999l,count) 
   if count gt 0 then h(index)=0
   index=where(z eq 99999l,count)
   if count gt 0 then z(index)=0
   index=where(x eq 99999l,count)
   if count gt 0 then x(index)=0
   index=where(y eq 99999l,count)
   if count gt 0 then y(index)=0
   index=where(f eq 99999l,count)
   if count gt 0 then f(index)=0
   index=where(d eq 99999l,count)
   if count gt 0 then d(index)=0

;select only data of interest

   index=where((time ge xut1) and (time le xut2),count)
   if count ge 2 then begin
      time=time(index)
      h=h(index)
      z=z(index)
      x=x(index)
      y=y(index)
      f=f(index)
      d=d(index)      
   endif

end
