;******************************************************************************
;* FILE:	 
;*    papco_addin_polar_mfe.pro
;* 
;* DESCRIPTION:  
;*    Sets up paths to programs for POLAR MFE
;*
;* CALLED BY:  papco_include_addins.pro
;*
;* MODIFICATION HISTORY:       
;*    written June 2000, R.Friedel
;******************************************************************************
print,''
print, '--- Including programs for POLAR CEPPAD PITCH addins -----------------'
print,''

POLAR_CEPPAD = '/n/toaster/u/friedel/idl/polar/ceppad'
print, 'adding path: '+ POLAR_CEPPAD
!path = !path + ':' + expand_path(POLAR_CEPPAD)

print, 'adding path to JHU astronomical programs'
!path = !path + ':' + expand_path('+/n/vendor/lib/idl-contrib/jhu')

print, 'compling RAL code and setting paths'
@ral_env_2.0_lanl

print, 'compiling POLAR CEPPAD PITCH routines'
@polar_ceppad_pitch_init

print,''
print, '--- End include POLAR CEPPAD PITCH addins ----------------------------'
print,''
