;******************************************************************************
;* FILE:	 
;*    papco_addin_ral_ceppad.pro
;* 
;* DESCRIPTION:  
;*     Sets up paths to RAL ceppad directory & compiles required procedures.
;*
;* CALLED BY:  papco_include_addins.pro
;*
;* MODIFICATION HISTORY:       
;*     written July 1998, R.Friedel
;******************************************************************************
print,''
print, '--- Including programs RAL CEPPAD if processing ----------------------'

RAL_CEPPAD = '/u/friedel/idl/RAL_CEPPAD/sw'
polar_ceppad = '/u/friedel/idl/polar/ceppad'

print, 'adding path: +' + polar_ceppad
!path = !path +':'+ expand_path('+'+polar_ceppad)

print, 'adding path: +' + RAL_CEPPAD
!path = !path +':'+ expand_path('+'+RAL_CEPPAD)

print, 'adding path to JHU astronomical programs'
!path = !path + ':' + expand_path('+/n/vendor/lib/idl-contrib/jhu')

print, '--- Compling RAL code and setting paths-------------------------------'
@ral_env_2.0_lanl

print, '--- End include RAL CEPPAD if processing addins ----------------------'
print,''
