;******************************************************************************
;* FILE:	$PAPTO_PATH/papco_compile.pro
;* 
;* DESCRIPTION: Run the initialisation files to freshly compile (.run) 
;*              PAPCO core and PAPCO modules.
;*
;* CALLED BY:   idl_papco_startup
;*
;* MODIFICATION HISTORY:  written July 1997, R.Friedel
;******************************************************************************
print, ''
print, '--- Start papco_compile ----------------------------------------------'

; calling papco_init: compile PAPCO core 
@papco_init

print, ''
print, '--- Compile add-in modules: only those found in module paths: --------'
print, ''

papco_find_modules
COMMON module_paths, paths

if paths(0) eq '' then print,'% papco_compile: No modules configured for PAPCO'

; calling papco_add_init: compile the modules found
@papco_add_init

print, ''
print, '--- End papco_compile ------------------------------------------------'
print, ''


