;******************************************************************************
;* FILE:        $PAPCO_USER/papco_set_variables.pro  
;* 
;* DESCRIPTION: Sets env. variables and expands IDL path as needed by PAPCO
;*
;* CALLED BY:   papco_startup, papco_setup
;*
;* MODIFICATION HISTORY:  written July 1997, R.Friedel
;*                        updated for papco_09 August 1998
;*                        updated for papco_10 January 2003
;*                        updated for WINDOWS July 2003
;******************************************************************************

; Environmental Variables that may be set outside of IDL/PAPCO:

; local variables used here:
; HOME       - user's home directory
; PAPCO_BASE - base directory where the PAPCO code resides
; PAPCO_DLNK - base drectory for data tree links
; PAPCO_HOME - user's papco_user directory

; NOTE:  (UNIX users) 
;  use UNIX path/file syntax!  ( /path/subdir/file )
;  Do not use the '~' notation for your home directory: PAPCO will then fail to
;  perform operations that depend on the IDL routine "findfiles" (findfiles
;  cannot parse a '~'). Use '$HOME' or the complete directory name instead.

; NOTE:  (WINDOWS users)
;  use WINDOWS path/file syntax! ( C:\path\file )
;  Environmental variables are set in
;  start -> settings -> control panel -> system -> advanced


;------------------------------------------------------------------------------
;set up the correct path seperator for current operating system:
!quiet = 1
sep = papco_get_pathsep()
psp = papco_get_dirsep()

;------------------------------------------------------------------------------
;         *** Begin section that may need modifying by user ***

; PAPCO_BASE       base directory where the PAPCO code resides
; PAPCO_HOME       user's papco_user directory

;PAPCO_BASE=    getenv('HOME')+'/idl/papco'    ;user version at LANL
;PAPCO_BASE=     '/n/projects/papco/papco'     ;public version at LANL
PAPCO_BASE=     '/home/jbf/ct/papco/working/papco'           
PAPCO_HOME=     '/home/jbf/ct/papco/papcoUsers/papco_user'

PAPCO_DLNK=     '/papco_data'


; USER_MOUSE_ACTIONS are used to configure new mouse actions by the user
USER_MOUSE_ACTIONS='Hydra_fV_Slice/' + $  
                   '3DD_Slice/'+ $
                   'Cluster_Boundary/' + $ 
                   'Cluster_4SC_3D_view/' + $
                   'MULTI_VERT_slice/' + $ 
                   'LVAL_slice/' + $ 
                   'MPA_Energy_Flux_Slice/'+ $
                   'MPA_Diff_Flux_Slice/'+ $
                   'MPA_Phase_Space_Density_Slice'

; USER_SHOW_ACTIONS selects the action in the draw window associated
;                   with the above USER_MOUSE_ACTIONS
USER_SHOW_ACTIONS= 'vert_line/' + $
                   'vert_line/' + $
                   'vert_line/' + $
                   'vert_line/' + $
                   'vert_line/' + $
                   'vert_line/' + $
                   'vert_line/' + $
                   'vert_line/' + $
                   'vert_line'

; Set up some outside utility programs used by PAPCO through spawn
; calls. If you do not set these variables, the default names / paths
; are used. These will be different for different operating systems!

;UNIX / MAC OS 10:
PAPCO_UNZIP = 'unzip'       ;default, must accessible on user path
PAPCO_WGET = 'wget'         ;default, must accessible on user path

;WINDOWS
;PAPCO_UNZIP = 'WZUNZIP'    ;default, must accessible on WINDOWS path
;PAPCO_WGET = 'WGET'        ;default, must accessible on WINDOWS path

; JBF: colors
device, decomposed=0
device, pseudo_color=8

;         *** End section that may need modifying by user ***
;------------------------------------------------------------------------------
;            *** DO NOT modify anything below this line ***    

print, '' 
print, '======================================================================'
print, '--- W E L C O M E   T O   P A P C O ! --------------------------------'
print, '======================================================================'
print, ''
print, '--- Start papco_set_variables ----------------------------------------'

PAPCO_CONFIG =  PAPCO_HOME + '/'
PAPCO_DOWNLOAD= PAPCO_HOME + sep + 'papco_download_temp'
 
;overwrite PAPCO_CONFIG if environmental variable PAPCO_TEMP_CONFIG is set
temp = getenv('PAPCO_TEMP_CONFIG')
IF temp NE '' THEN PAPCO_CONFIG =  PAPCO_HOME + sep+ temp $
ELSE PAPCO_CONFIG =  PAPCO_HOME

print, '--- Expanding IDL search path for PAPCO core, Lib, Home --------------'

!path = !path + psp + PAPCO_BASE + sep + 'papco'   
!path = !path + psp + expand_path('+'+PAPCO_BASE+ sep +'papco_lib')
!path = !path + psp + PAPCO_HOME

; compile module that contains all routines for platform
; independance. This needs to be done right at the beginng, here!

print, '--- Compile PAPCO routines needed for startup ------------------------'
@papco_startup_init

; print out the current PAPCO version.
print, ''
print, '======================================================================'
print, papco_version()
print, '======================================================================'

; setting all environmental variables need by PAPCO.

; PAPCO_QUIET, PAPCO_STARTUP_MODE and PAPCO_ADDINS: used by the startup widget
papco_setenv,      'PAPCO_QUIET=1' 
papco_setenv,      'PAPCO_STARTUP_MODE=COMPILE' 
papco_setenv,      'PAPCO_ADDINS=YES' 

; PAPCO_HOME, PAPCO_CONFIG, PAPCO_PATH, PAPCO_MODULES, PAPCO_DOC, PAPCO_LIB
; PAPCO_DOWNLOAD, TIME_CONV  are used by the papco core programs
papco_setenv, /FS, 'PAPCO_HOME='+PAPCO_HOME
papco_setenv, /FS, 'PAPCO_CONFIG='+PAPCO_CONFIG
papco_setenv, /FS, 'PAPCO_PATH='+PAPCO_BASE+ sep +'papco'
papco_setenv, /FS, 'PAPCO_DOC='+PAPCO_BASE+ sep +'papco_doc'
papco_setenv, /FS, 'PAPCO_LIB='+PAPCO_BASE+ sep +'papco_lib'
papco_setenv, /FS, 'PAPCO_MODULES='+PAPCO_BASE+ sep +'papco_modules'
papco_setenv, /FS, 'PAPCO_DOWNLOAD='+PAPCO_DOWNLOAD
papco_setenv, /FS, 'TIME_CONV='+PAPCO_BASE+sep+'papco_lib'+sep+'cdssw'+sep+'time'

papco_setenv,      'USER_MOUSE_ACTIONS='+USER_MOUSE_ACTIONS
papco_setenv,      'USER_SHOW_ACTIONS='+USER_SHOW_ACTIONS

papco_setenv,      'PAPCO_UNZIP='+PAPCO_UNZIP
papco_setenv,      'PAPCO_WGET='+PAPCO_WGET

papco_setenv,      'PAPCO_DLNK='+PAPCO_DLNK

!quiet=long(getenv('PAPCO_QUIET'))

@papco_show_variables

print, '--- Done papco_set_variables -----------------------------------------'




