;******************************************************************************
;* FILE:        $PAPCO_USER/papco_setup.pro
;* 
;* DESCRIPTION: first calls papco_configure and then papco_startup used if the 
;*              way in which PAPCO starts up needs to be changed,i.e.:
;*              a different set of modules is to be loaded
;*              the startup mode is to be changed (compile or restore)
;*
;* CALLED BY:   none
;*
;* HOW TO START:
;*    from command line: type idl papco_setup   (must be in current dir)
;*        or, in your shell set up an environmental variable IDL_INITIALIZE
;*        which points to the location of papco_setup
;*        eg for ksh:  IDL_STARTUP=~/papco_setup
;*                     export IDL_STARTUP
;*        then simply type idl
;*    from IDL:   type @papco_setup (if papco_setup.pro in local dir)
;*             or type @PATH/papco_setup (if papco_setup.pro in PATH)
;*    afterwards, you can start PAPCO by executing the command "papco".
;*
;* MODIFICATION HISTORY:  written July 1997, R.Friedel
;******************************************************************************

; set up some variables used in this startup file
@papco_set_variables

; call configure widget and change papco_startup file 
print, ''
print, '--- Running papco Configure widget -----------------------------------'
print, ''

papco_configure
papco_change_startup

print, ''
print, '--- Done papco Configure ---------------------------------------------'

; Run normal papco_startup
@papco_startup
