;******************************************************************************
;* FILE:        $PAPCO_USER/papco_show_varibales.pro
;* 
;* DESCRIPTION: reports environmental variables set by PAPCO
;*
;* CALLED BY:   papco_set_variable, papco_startup
;*
;* MODIFICATION HISTORY:  written August 2002, R.Friedel
;******************************************************************************
print, ''
print, '--- Environmental variables now set: ---------------------------------'
print, ''
print, 'PAPCO_QUIET:        ',getenv('PAPCO_QUIET')
print, 'PAPCO_STARTUP_MODE: ',getenv('PAPCO_STARTUP_MODE')
print, 'PAPCO_ADDINS:       ',getenv('PAPCO_ADDINS')
print, 'PAPCO_HOME:         ',getenv('PAPCO_HOME')
print, 'PAPCO_CONFIG:       ',getenv('PAPCO_CONFIG')
print, 'PAPCO_PATH:         ',getenv('PAPCO_PATH')
print, 'PAPCO_MODULES:      ',getenv('PAPCO_MODULES')
print, 'PAPCO_DOWNLOAD:     ',getenv('PAPCO_DOWNLOAD')
print, 'TIME_CONV:          ',getenv('TIME_CONV')
print, 'POLAR_ORBITS:       ',getenv('POLAR_ORBITS')
print, 'CRRES_ORBITS:       ',getenv('CRRES_ORBITS')
print, 'AMPTE_ORBITS:       ',getenv('AMPTE_ORBITS')
print, 'USER_MOUSE_ACTIONS:                       USER_SHOW_ACTIONS:'
uma=str_sep(getenv('USER_MOUSE_ACTIONS'),'/')
usa=str_sep(getenv('USER_SHOW_ACTIONS'),'/')
for i=0,n_elements(uma)-1 DO $
  print,'  ',strFormat(uma(i), 40, /LEFT), '  ',strFormat(usa(i), 15, /LEFT)
print, ''
