;******************************************************************************
;* FILE:        $PAPCO_USER/papco_startup.pro
;* 
;* DESCRIPTION: initializes PAPCO
;*
;* CALLED BY:   papco_setup
;*
;* HOW TO START:
;*    from command line: type idl papco_startup   (must be in current dir)
;*        or, in your shell set up an environmental variable IDL_STARTUP
;*        which points to the location of papco_startup
;*        eg for ksh:  IDL_STARTUP=~/papco_startup
;*                     export IDL_STARTUP
;*        then simply type idl
;*    from IDL:      type @papco_startup (if papco_startup.pro in local dir)
;*                or type @PATH/papco_startup (if papco_startup.pro in PATH)
;*    then you can start PAPCO by executing the command "papco".
;*
;* MODIFICATION HISTORY:  written July 1997, R.Friedel
;******************************************************************************

; Set up some variables used in this startup file
@papco_set_variables

; Set location of configuration to be used
papco_config = getenv('PAPCO_CONFIG')
papco_home = getenv('PAPCO_HOME')

print, ''
print, '--- Start papco_startup ----------------------------------------------'
print, ''
print, '--- Module Paths and module data path env. var. settings -------------'
print, ''

IF papco_config NE '' THEN CD, papco_config
@papco_include_modules.pro

IF papco_config NE '' THEN CD, papco_config
@papco_include_addins
CD, papco_home

if !error eq -170 then $
 print,'% PAPCO_STARTUP: Use @papco_setup to first configure modules for PAPCO'
CD, papco_home

; compiling/Restoring PAPCO
@papco_compile

; force quiet mode off to see idl messages
!quiet=0

@papco_show_variables

print, '--- Done papco_startup -----------------------------------------------'
