function bcomponent_error, t0, bcomp0, label=label, bvalid=bvalid0, $
                           simple=simple, plot=plot
;
;   Calculate the difference between the time-series for a component
;   and the filtered series
;

n=n_elements(t0)

if keyword_set(bvalid0) then begin

    bvalid=reform(bvalid0)

    dv=bvalid(1:n-1)-bvalid(0:n-2)

    r=[-1,where(dv ne 0,nr),n-1]

    if nr gt 0 then begin
        rfill = -1.0e-31
        berr=replicate(rfill,n)
        
        for i=0,nr,2 do begin
            rr=indgen(r(i+1)-(r(i)+1))+r(i)+1
            t=t0(rr)
            bc=bcomp0(rr)
            bv=bvalid(rr)
            
            berr(rr)=bcomponent_error(t,bc,label=label)
            
        endfor
        return, berr
    endif else begin
        berr=bcomponent_error(t0,bcomp0,label=label)
    endelse
endif

dt=t0(1)-t0(0)
nfilter=2*long(0.121/dt)
if keyword_set(simple) then begin
    t=t0
    bcomp1=bcomp0
endif else begin
    t=[t0,t0+t0(n-1)+dt-t0(0)]
    bcomp1=[bcomp0,reverse(bcomp0)]
    n=2*n
endelse
t1=(t(n-1)-t(0))


n21=n/2+1

f=indgen(n)
f[n21:n-1]=n21-n+findgen(n21-2+n mod 2)
f=f/(n*t1)



fx=fft(bcomp1,-1)
if keyword_set(plot) then $
  plot, shift(f(0:n-2),-n21),shift(abs(fx),-n21)+1e-10, $
  xtickformat='tick_hms_whole', charsize=1.5, $
  title=label+': Fourier Transform Power', /ylog, yrange=[.1,max(abs(fx))]

fx(n21-nfilter-1:n21+nfilter)=0.0

if keyword_set(plot) then $
  oplot, shift(f(0:n-2),-n21),shift(abs(fx),-n21)+1e-10, linestyle=1

fx=fft(fx,1)
if keyword_set(simple) then begin
    fx1=fx
endif else begin
    fx1=fx(0:n/2-1)
endelse
if keyword_set(plot) then begin
    plot, t0, bcomp0, xtickformat='tick_hms_whole', charsize=1.5, $
      title=label+': Time Series'
    oplot, t0, fx

    plot, t0, abs(bcomp0-fx1), xtickformat='tick_hms_whole', charsize=1.5, $
      title=label+': Difference due to filter'
endif

return, abs(bcomp0-fx1)
end
