function bmag_8hz_nolag, t, bx, by, bz, bvalid, phi=phi, theta=theta, $
                         verbose=verbose, $
                         dbxs=dbxs, dbys=dbys, dbzs=dbzs
;
;   Inputs: MFE 8 Hz RAW field along with bvalid flag
;
;   Return value: B Magnitude at 8 Hz RAW w/no lag
;                 theta and phi return as 8 hz angles
;
;   Note: 
;         Reconstructs 100 Hz stream (as linearly-interpolated between
;         8-Hz times) for each B component such that when
;         filtered it recovers MFE 8 Hz data.
;
;
hd_fill=-1e31
n=n_elements(t)
use_bvalid=1
plot_values=0
print=0
;
;  Check for actual data-gaps in MFE B Times
;
st=0
dt=t(1:n-1)-t(0:n-2)
max=max(dt,min=min)
rt=where(dt gt 0.125, nrt)
rt0=where(dt lt 0.110, nrt0)
if (nrt gt 0) then begin
    for i=0L,nrt-1 do begin
        if (bvalid(rt(i)) ne 0) then begin
            message, 'Handling bvalid=1 at data gap: '+ $
              hydra_hms(t(rt(i)))+' dt='+strtrim(dt(rt(i)),2), /cont
        endif
    endfor
    st=1
endif
if (nrt0 gt 0) then begin
    for i=0L,nrt0-1 do begin
        if (bvalid(rt0(i)) ne 0) then begin
            message, 'Handling bvalid=1 at repeated data point: '+ $
              hydra_hms(t(rt0(i)))+' dt='+strtrim(dt(rt0(i)),2), /cont
        endif
    endfor
    st=1
endif
;if st eq 1 then stop

;
;   Handle data gaps with bvalid (N.B. This removes 2 8Hz points from 
;   the sequence.
for i=0L,nrt-1 do begin
    bvalid(rt(i):rt(i)+1)=0
endfor
for i=0L,nrt0-1 do begin
    bvalid(rt0(i):rt0(i))=0
endfor


fill=-1e+31
if use_bvalid then begin
;
;  Split into sections based on bvalid, storing the result in bmag.
;
    boundary=bvalid(1:n-1)-bvalid(0:n-2)
    rs=where(boundary eq 1, nrs)
    if nrs gt 0 then begin
        if (bvalid(0) eq 1) then rs=[0,rs+1] else rs=rs+1
    endif else begin
        rs=[0]
    endelse
    re=where(boundary eq -1, nre)
    if nre gt 0 then begin
        if bvalid(n-1) eq 1 then re=[re(0:nre-1),n-1]
    endif else begin
        re=[n-1]
    endelse
;
;   Split valid sequences into chunks of length nmax.
;
    nmax=500
    rs1=[-1L]
    re1=[-1L]
    for i=0L,n_elements(re)-1 do begin
        ;if i eq 10 then stop
        nrse=re(i)-rs(i)
        nr=nrse/nmax
        if ((nrse mod nmax) eq 0) and (nr ne 0) then nr=nr-1
        for j=0L, nr-1 do begin
            ;print, i,j,rs(i)+j*nmax,rs(i)+(j+1)*nmax-1, nrse, nr, nr*nmax
            rs1=[rs1,rs(i)+j*nmax]
            re1=[re1,rs(i)+(j+1)*nmax-1]
        endfor
        ;print, i,nr,rs(i)+(nr)*nmax, re(i), nrse, nr, nr*nmax
        rs1=[rs1,rs(i)+(nr)*nmax]
        re1=[re1,re(i)]
    endfor
    rs=rs1(1:n_elements(rs1)-1)
    re=re1(1:n_elements(re1)-1)

    bmag=fltarr(n)
    dbxs=fltarr(n)
    dbys=fltarr(n)
    dbzs=fltarr(n)
    theta=fltarr(n)
    phi=fltarr(n)
    bvalid0=intarr(n)
    if n_elements(rs) ne n_elements(re) then begin
        message, 'Error in BValid partitioning: ', /continue
        print, 'RS=', rs
        print, 'RE=', re
        stop
    endif
    bmag(*)=fill
    dbxs(*)=fill
    dbys(*)=fill
    dbzs(*)=fill
    theta(*)=fill
    phi(*)=fill
    bvalid0(*)=0
    for i=0L,n_elements(re)-1 do begin
        nrse=re(i)-rs(i)
        if nrse gt 3 then begin
            bxp=bx(rs(i):re(i))
            byp=by(rs(i):re(i))
            bzp=bz(rs(i):re(i))
            tp=t(rs(i):re(i))
            if keyword_set(verbose) then begin
                print, 'Solving for ['+strtrim(tp(0),2)+', '+$
                  strtrim(t(re(i)),2)+']   ['+strtrim(rs(i),2)+', '+$
                  strtrim(re(i),2)+'] of '+strtrim(n,2)+$
                  '  '+strtrim(i,2)
            endif
            solve_8hz_linear, bxp, byp, bzp, tp, bxn, byn, bzn, $
              plot_values=plot_values, print=print

            rb=where(bxn eq hd_fill and byn eq hd_fill and bzn eq hd_fill)
            if rb(0) ne -1 then message, 'B NO_LAG Fill Data Error.'
            bmag(rs(i):re(i))=sqrt(bxn^2+byn^2+bzn^2)

            dbxs(rs(i):re(i))=abs(bxp-bxn)
            dbys(rs(i):re(i))=abs(byp-byn)
            dbzs(rs(i):re(i))=abs(bzp-bzn)

            theta(rs(i):re(i))=acos(bzn/bmag(rs(i):re(i)))
            phi(rs(i):re(i))=atan(byn,bxn)
            bvalid0(rs(i):re(i))=1
        endif
    endfor
    rphi=where(phi lt 0)
    if rphi(0) ne -1 then phi(rphi)=phi(rphi)+2.0*!pi
    bvalid=bvalid0

endif else begin
;
;  Split into managable sections of length np and calculate each section,
;  storing the result in bmag.
;
    np=500.0
    n0=n/np
    if n0-long(n0) lt 0.2 then n0=long(n0-1)
    bmag=fltarr(n)
    for i=0L, n0-2 do begin
        tp=t(i*np:(i+1)*np)
        bxp=bx(i*np:(i+1)*np)
        byp=by(i*np:(i+1)*np)
        bzp=bz(i*np:(i+1)*np)
        solve_8hz_linear, bxp, byp, bzp, tp, bxn, byn, bzn
        bmag(i*np:(i+1)*np)=sqrt(bxn^2+byn^2+bzn^2)
    endfor
    n1=n0-1
    tp=t(n1*np:n-1)
    bxp=bx(n1*np:n-1)
    byp=by(n1*np:n-1)
    bzp=bz(n1*np:n-1)
    solve_8hz_linear, bxp, byp, bzp, tp, bxn, byn, bzn
    bmag(n1*np:n-1)=sqrt(bxn^2+byn^2+bzn^2)

    r=where((abs(bx)+abs(by)+abs(bz)) gt 1e+10,nr)
    if nr gt 0 then bmag(r)=fill
endelse

return, bmag
end
