pro gb_lag_corr_angle_error, t, thetab, phib, thetab0, phib0, $
                              bvalid, rfill, angle_error
;
;  Calculate 
;
;
verbose_plot=0
;
;
bhxp=cos(phib)*sin(thetab)
bhyp=sin(phib)*sin(thetab)
bhzp=cos(thetab)

bhx0p=cos(phib0)*sin(thetab0)
bhy0p=sin(phib0)*sin(thetab0)
bhz0p=cos(thetab0)

angle_error=abs(acos(bhxp*bhx0p+bhyp*bhy0p+bhzp*bhz0p))/!dtor
ra=where(bvalid eq 0)
if (ra(0) ne -1) then angle_error(ra)=rfill

if verbose_plot then begin

    time=t
    nn0=n_elements(phib0)

    rp=where(bvalid(0:nn0-1) eq 1)
    thetabp=thetab(rp)
    thetab0p=thetab0(rp)
    phibp=phib(rp)
    phib0p=phib0(rp)
    tp=t(rp)
    bmagp=bmag(rp)
    dots, /fill

    set_page, nv=4, nh=1
    yrange_theta=[min([thetabp,thetab0p],max=max)-.10,$
                  max+.10]/!dtor
    yrange_phi=[min([unwrap_phi(phibp),unwrap_phi(phib0p)],max=max)-.10,$
                max+.10]/!dtor

    bhxp=cos(phibp)*sin(thetabp)
    bhyp=sin(phibp)*sin(thetabp)
    bhzp=cos(thetabp)

    bhx0p=cos(phib0p)*sin(thetab0p)
    bhy0p=sin(phib0p)*sin(thetab0p)
    bhz0p=cos(thetab0p)

    dangle=abs(acos(bhxp*bhx0p+bhyp*bhy0p+bhzp*bhz0p))

    plot, tp, thetabp/!dtor, charsiz=1.5, $
      yrange=yrange_theta, psym=1, $
      ytitle='ThetaB (degrees)', xtickformat='tick_hms_whole'
    oplot, tp, thetab0p/!dtor, psym=8, symsize=0.4
    
    plot, tp, unwrap_phi(phibp)/!dtor, charsiz=1.5, $
      yrange=yrange_phi, psym=1, $
      title='PhiB (degrees)', xtickformat='tick_hms_whole'
    oplot, tp, unwrap_phi(phib0p)/!dtor, psym=8, symsize=0.4

    plot, tp, dangle/!dtor, charsiz=1.5, $
      psym=3, $
      title='Angular Error (degrees)', xtickformat='tick_hms_whole'

    plot, tp, bmagp, charsiz=1.5, psym=8, symsize=0.4, $
      title='Bmag', xtickformat='tick_hms_whole'
endif
return
end
