pro gen_bfield_fill_in,  bx, by, bz, bflags, bvalid, bt

; NAME: gen_bfield_fill_in
;
; PURPOSE: fill in data gaps by robustly interpolating
;
; INPUTS:
;   bx, by, bz   bfield data at 27 or 54 hz
;   bflags       bflags=1 indicates hydra_filter is on (ignored)
;   bvalid       bvalid=0 interpolate these points
;   bt           timetags for each bx,by,bz.  Only interpolate
;                  up to one minute's worth of data
;
; OUTPUTS:
;   fills in bx, by, bz in situ.
;
; RESTRICTIONS:
;   will not fill in gaps at the beginning or end!
;
; PROCEDURE:
;   foreach gap, grab a number of points on each end of the gap and 
;     average them.  Interpolate between these averages.
;
; MODIFICATION HISTORY:
;   Written, jbf, 7 March 2002.


  if (where(bvalid eq 0))[0] eq -1 then return
  
  u= uniq( bvalid )

  r= where( bvalid(u) eq 0, icount )
  if r[0] eq 0 then begin
      if icount eq 1 then return
      u= u[1:*]
      r= r[1:*]-1
      icount= icount-1
  endif

  if r[icount-1] eq n_elements(u)-1 then begin
      if icount eq 1 then return
      u= u[0:(n_elements(u)-2)]
      r= r[0:(icount-2)]
      icount= icount-1
  endif

  nb= n_elements(bx)
  
  for ir= 0,icount-1 do begin      
      u1= u[r[ir]-1]+1
      u2= u[r[ir]]

      if (bt[u2]-bt[u1]) lt 60. then begin
          
          npts= 10
          rpts= (u1-1)-indgen(npts)
          rr= where( rpts ge 0 and bvalid(rpts > 0) eq 1, npts )
          rpts= rpts[rr]
          
          avg1_idx= total(rpts)/npts
          avg1x= total(bx[rpts])/npts
          avg1y= total(by[rpts])/npts
          avg1z= total(bz[rpts])/npts
          
          npts= 10
          rpts= (u2+1)+indgen(npts)
          rr= where( rpts lt nb and bvalid(rpts < (nb-1)) eq 1, npts )
          rpts= rpts[rr]
          
          avg2_idx= total(rpts)/npts
          avg2x= total(bx[rpts])/npts
          avg2y= total(by[rpts])/npts
          avg2z= total(bz[rpts])/npts
          
          rinterp= indgen( u2-u1+1 ) + u1
          
          findex= ( rinterp - avg1_idx ) / ( avg2_idx - avg1_idx )
          bx_interp= avg1x * ( 1-findex ) + avg2x * ( findex )
          by_interp= avg1y * ( 1-findex ) + avg2y * ( findex )
          bz_interp= avg1z * ( 1-findex ) + avg2z * ( findex )
          
          bx(u1:u2)= bx_interp
          by(u1:u2)= by_interp
          bz(u1:u2)= bz_interp
          
          bflags(u1:u2)= bflags(u1:u2) or 8
          bvalid(u1:u2)= 1
      endif
      
  endfor

end
