pro testit
  cdfraw= cdf_open( hydra_findfile( 20010401, /level1 ))
  cdfcal= cdf_open( '/home/jbf/scratch/mfe_offsets2/20010401_hyd_ddcal_v7.65.cdf' )
  gen_bfield, cdfraw, cdfcal=cdfcal, 263, 130, $
    /xyz, bx=bx1, by=by1, bz=bz1, bt=t1, /fixed_payload, $
    /verbose, lag_correct=0
  gen_bfield, cdfraw, cdfcal=cdfcal, 263, 130, $
    /xyz, bx=bx0, by=by0, bz=bz0, bt=t0, spin_filter=0, /fixed_payload
  stop
end

function gen_bfield_spin_filter, cdfcal, $
                                 time, phase, b, $
                                 fixed_payload=fixed_payload

  cdf_control, cdfcal, var='HYD_MFE_SPIN_TONE_TIME_RANGE_SSM', /zvar, get_var_info=r
  hyd_cdf_varget, cdfcal, 'HYD_MFE_SPIN_TONE_TIME_RANGE_SSM', time_range, rec_count=r.maxrec+1

  hyd_cdf_varget, cdfcal, 'HYD_MFE_SPIN_TONE', spin_tone_phasor, rec_count=r.maxrec+1
  hyd_cdf_varget, cdfcal, 'HYD_MFE_TWICE_SPIN_TONE', twice_spin_tone_phasor, rec_count=r.maxrec+1
  
  iwin1=0
  iwin2=0
  
  r= where( time_range[0,*] ne -1e31, count )
  for ir=0,count-1 do begin
      itime_range= r[ir]

      st= time_range[0,itime_range]
      et= time_range[1,itime_range]
      rt= where( st le time and $
                 time lt et )

      if rt[0] ne -1 then begin
          for icomp=0,2 do begin

              phase0= phase(rt)

              phase1= hd_phase_unroll(phase0)
              
              xx= hyd_filter_freq( phase1, b[icomp,rt], !pi, phasor= phasor )
              phasor2_t= $
                ( hyd_rotm(phase1[0]) # [ phasor,0 ] )[0:1]
              
              xx= hyd_filter_freq( phase1, xx, 2*!pi, phasor= phasor ) 
              phasor1_t= $
                ( hyd_rotm(phase1[0]) # [ phasor,0 ] )[0:1]

              phasor2= twice_spin_tone_phasor[*,icomp,itime_range]
              bnew= b[icomp,rt] $
                - ( phasor2[0] * cos(2*phase[rt]) $
                    + phasor2[1] * sin(2*phase[rt]) )              

              phasor1= spin_tone_phasor[*,icomp,itime_range]
              bnew= bnew $
                - ( phasor1[0] * cos(phase[rt]) $
                    + phasor1[1] * sin(phase[rt]) )

              hd_make_timetags, ttag, time, /width_is_delta12

              gb= {  phase:phase1, $
                     bx:b[icomp,rt], $                    
                     phasor2_t:phasor2_t, $
                     phasor2:phasor2, $
                     time:time[rt], $
                     ttag:ttag[rt], $
                     phasor1:phasor1, $
                     phasor1_t:phasor1_t }
              save, file='/home/jbf/temp/gb.idlsav', gb
              stop
              b[icomp,rt]= bnew

          endfor
      endif
  endfor

  stop

  result= transpose( reform( [ bx, by, bz ], n_elements(bx), 3 ) )
  return, result
end
