pro gen_bfield_wrap, date, $
                     start_time=start_time_in, $
                     end_time=end_time_in, $
                     bx=bx, $
                     by=by, $
                     bz=bz, $
                     bvalid=bvalid, $
                     time=bt, $
                     _extra=e

;   specify start and end time
    start_time= start_time_in       ; hours since midnight
    end_time= end_time_in 

;   open the level1 can calibration file
    f= hydra_findfile( date, /level1 )
    if f eq '' then begin
        message, 'Level1 file note found.', /cont
        return
    endif
    raw= cdf_open( hydra_findfile( date, /level1 ))
    cal= cdf_open( hydra_findfile( date, /ddcal ))
    
;   find the records that correspond to the interval [start_time,end_time]
    cdf_control, raw, variable='BLOCK_TIME', get_var_info=r
    hyd_cdf_varget, raw, 'BLOCK_TIME', time_epoch, rec_start=0, rec_count=r.maxrec
    time_hr= time_epoch mod (86400*1000.) / (3600*1000L)
    r= where( time_hr ge start_time and time_hr le end_time, count )
    
    rec_start= r(0)
    rec_count= r(count-1) - r(0) + 1

    gen_bfield, raw, cdfcal=cal, rec_start, rec_count, $
      bx=bx, by=by, bz=bz, time=bt, $
      _extra=e

end
