pro testit
  get_bfield_angles, 20000416, 5.0, 5.1, $
    time_out_hsm, b_phi_payload_out, b_theta_payload_out, $
    b_valid_out
  r= where( b_valid_out eq 0 )
  if r(0) ne -1 then begin
      b_phi_payload_out(r)=!values.f_nan 
      b_theta_payload_out(r)=!values.f_nan
  endif
  plot, time_out_hsm, b_phi_payload_out, ytitle='B phi payload'
  plot, time_out_hsm, b_theta_payload_out, ytitle='B theta payload'  
end

pro get_bfield_angles, dateYYYYMMDD, time_start_hsm, time_end_hsm, $
                       time_out_hsm, b_phi_payload_out, b_theta_payload_out, $
                       b_valid_out

  if n_params() eq 0 then begin
      print, 'usage: '
      print, 'get_bfield_angles, dateYYYYMMDD, time_start_hsm, time_end_hsm,$' 
      print, '  time_out_hsm, phi_payload_out, theta_payload_out, bvalid_out'
      stop
  endif

  fraw= hydra_findfile( dateYYYYMMDD, /level1 )
  fcal= hydra_findfile( dateYYYYMMDD, /ddcal )

  if fraw(0) eq '' then begin
      print, 'Level 1 file not found.'
      stop
  endif
  
  raw= cdf_open( fraw )
  cal= cdf_open( fcal )
  
  cdf_control, raw, variable='BLOCK_TIME', get_var_info=r
  hyd_cdf_varget, raw, 'BLOCK_TIME', time_epoch, rec_start=0,rec_count=r.maxrec
 
  time_hr= time_epoch mod (86400*1000.) / (3600*1000L)
  r= where( time_hr ge time_start_hsm and time_hr le time_end_hsm, count )
  
  rec_start= r(0)
  rec_count= r(count-1) - r(0) + 1
  
  if rec_start eq -1 or count le 0 then begin
      print, 'Problem with time interval specification (time_start_hsm,time_end_hsm)'
      stop
  endif

  gen_bfield, raw, cdfcal=cdl, rec_start, rec_count, $
    /thetaphi, btheta=b_theta_payload_out, bphi=b_phi_payload_out, $
    time=time_out_ssm, bvalid= b_valid_out, /Hz54, /fixed_payload, $
    /nobmag, /nocorrect
 
  time_out_hsm= time_out_ssm/3600.

end


