pro get_hr_bmag_rdh, f, rec_start, rec_count, bmag, t, $
                     hydtim=hydtim, Hz50=Hz50, $
                     reset=reset, $
                     bx_return=bx_return, by_return=by_return, $
                     bz_return=bz_return

;  get_hr_bmag 
; 
;  purpose:  retrieves 8Hz Bfield magnitude data from hydra l1 file.
;      Handles interpolation to hydra sample times.  Also, maintains
;      a buffer of the last load.  In case of multiple reads.
;
;  /reset   clears internal buffer
;
;  written: ??/??/?? Jeremy Faden
;  history: Dec 5, 1997  Added buffer and above comments.

;           Jan 13, 1998 RDH added bx/by/bz_return keywords to return
;                            B interpolated by components.


;  buffer is identified by "BLOCK_TIME" of first measurement.
;
;  added *_rdh 1/13/98
;
   common get_hr_bmag_common, id_, rec_start_, rec_count_, bmag_, t_
   COMMON get_hr_bmag_common_rdh, bx_, by_, bz_

   if keyword_set( reset ) then begin
       if n_elements( id_ ) gt 0 then begin
           message, 'clearing buffer', /cont
           z= temporary(id_)
       endif
       return
   endif
     
   if n_elements( id_ ) gt 0 then begin
       hyd_cdf_varget, f, 'BLOCK_TIME', id, rec_start=rec_start_
       if rec_start_ le rec_start and $
         rec_start_ + rec_count_ ge rec_start + rec_count  and $
         keyword_set(hydtim) and $ 
         id_ eq id then begin
           message, 'Using stored data...', /cont
           r= ( rec_start - rec_start_ ) + lindgen( rec_count )
           bmag= bmag_(*,r)
;
;%%%%%%%%%%%%%% 1/13/98
           bx_return = bx_(*,r)
           by_return = by_(*,r)
           bz_return = bz_(*,r)
;%%%%%%%%%%%%%%
;
           t=t_(*,r)
           return
       endif
   endif

   hyd_cdf_varget, f, 'BLOCK_MJF', block_mjf, $
     rec_start=rec_start, rec_count=rec_count
   
   in= min( block_mjf, max=num )
   num= num-in+1+1  ; grab an extra block since mfe data lags hydra 
   
   hyd_cdf_varget, f, 'B_HIGH_RAW', b_raw, $
     rec_start= in, rec_count= num

   hyd_cdf_varget, f, 'B_HIGH_TIME', mjftime, $
     rec_start= in, rec_count= num
   mjftime= reform( mjftime )
   
   hyd_cdf_varget, f, 'B_HIGH_DT', deltat, $
     rec_start= in, rec_count= num
   deltat= reform( deltat )

   nn= n_elements( b_raw(*,0,0) ) 

   bx= intarr( num*nn )
   by= intarr( num*nn )
   bz= intarr( num*nn )
   t= dblarr( num*nn )

;  fill t
   offsets= intarr( nn, num )
   for i=0,num-1 do begin
       offsets( *, i ) = indgen(nn)
   endfor

   t(*)= rebin( mjftime, num*nn, /sample ) + offsets(*) * $
     rebin( deltat, num*nn, /sample )

   bx= reform(b_raw(*,0,*), num*nn )
   by= reform(b_raw(*,1,*), num*nn )
   bz= reform(b_raw(*,2,*), num*nn )
   
   r= where( bx ne -1  or  by ne -1  or  bz ne -1 )

   if r(0) ne -1 then begin
       t=t(r)
       bx=float(bx(r))
       by=float(by(r))
       bz=float(bz(r))
       bmag= sqrt( bx^2 + by^2 + bz^2 )
   endif

   hydtim= keyword_set( hydtim )
   Hz50=  keyword_set( Hz50 )
   
   if hydtim or Hz50 then begin ; interpolate to hydra samples
       hyd_cdf_varget, f, 'BLOCK_TIME', block_time, $
         rec_start=rec_start, rec_count=rec_count
       id= block_time(0)
       block_time= block_time(*)
       block_time= block_time mod 86400000. / 1000 ; convert to seconds
       hyd_cdf_varget, f, 'BLOCK_MODE', block_mode, $
         rec_start=rec_start
       hyd_cdf_varget, f, 'TIME_OFFSET', time_offset, rec_start=block_mode-1

;      fill t with hydra times
       if hydtim then begin
           n=384
           t_h= make_array( n, /float, value=1 ) # block_time + $
             time_offset # make_array( rec_count, /float, value=1 )
       endif else begin
           n=768           
           dt1= -0.0138         ; first Bangle is 13.8ms before DDEIS
           dt2= +0.0042         ; second Bangle comes 4.2ms later then DDEIS 
           time_offset= rebin( time_offset, 768, /sample )
           time_offset(indgen(384)*2)=time_offset(indgen(384)*2)+dt1
           time_offset(indgen(384)*2+1)=time_offset(indgen(384)*2+1)+dt2
           t_h= make_array( n, /float, value=1 ) # block_time + $
             time_offset # make_array( rec_count, /float, value=1 )
       endelse
       bmag_h= interpol( bmag, t+.5*deltat(0), t_h(*) )
;
;%%%%%%%%%%%%%% 1/13/98
       bx_h = interpol( bx, t+.5*deltat(0), t_h(*) )
       by_h = interpol( by, t+.5*deltat(0), t_h(*) )
       bz_h = interpol( bz, t+.5*deltat(0), t_h(*) )
       bx_return = bx_h
       by_return = by_h
       bz_return = bz_h
;%%%%%%%%%%%%%%
;
       bmag= reform(bmag_h,n,rec_count)
       t= t_h





;      store in buffer for next guy
       if (hydtim) then begin
           id_= id
           rec_start_= rec_start
           rec_count_= rec_count
           bmag_= bmag
;
;%%%%%%%%%%%%%% 1/13/98
           bx_= bx_return
           by_= by_return
           bz_= bz_return
;%%%%%%%%%%%%%%
;
           t_= t       
       endif
   endif                        ; if (hydtim)

   return
end
