function hd_filter_histogram, array, binsize=binsize, $
                              min=binmin, max=binmax, pad=pad, $
                              fraction=fraction, verbose=verbose, $
                              title=title
;
;   Return the indexes of points to survive the filtering
;
;   A histogram is performed, and points more than 'pad' away from a bin
;   with greater than fraction*max # in a bin.
;
;   Array:    Input to be filtered
;
;   binsize=binsize:    of the histogram
;   min=min, max=max:   of the histogram
;   pad=pad:            Filtered points must be more than this distance
;                       from any "good" points.
;   fraction=fraction:  Good bins have max#*fraction points.
;
;   /verbose:           Make Plot of workings
;   title=title:        Title for Plots
;
if not keyword_set(title) then title='HD_Filter_Histogram: Array'
if not keyword_set(fraction) then fraction=0.01
if not keyword_set(pad) then pad=0.0002
if not keyword_set(binmin) then binmin=min(array)
if not keyword_set(binmax) then binmax=max(array)
if not keyword_set(binsize) then binsize=(max-min)/100.0

histogram_rdh, array, x, y, binsize=binsize, min=binmin, max=binmax
ymax=max(y)
rgood=where(y gt fraction*ymax, nrgood)
tgood_min=x[rgood[0]]-pad
tgood_max=x[rgood[nrgood-1]]+pad
r_outlier=where((y lt fraction*ymax) and (y gt 0) and $
                ((x lt tgood_min) or $
                 (x gt tgood_max)), nr)
r_toutlier=where(array lt tgood_min or array gt tgood_max)
rfilter=r_toutlier
if keyword_set(verbose) then begin
    set_page, nv=2
    plot, array, psym=3, /ynoz, ystyle=2, $
      title=title+' Data', xtitle='Index'
    oplot, rfilter, array[rfilter], psym=2
    r=where(y gt 0, nr)
    plot, x, y > 0.1, psym=10, xrange=[x[r[0]],x[r[nr-1]]], /ylog, $
      title=title+' Histogram', ytitle='Freq.', xtitle='Bins'
    oplot, x(r_outlier), y(r_outlier), psym=2
    label_page
endif
return, rfilter
end
