function hd_spin_period, date, CDF=CDF, duntim=duntim, all=all, $
                         verbose=verbose
;
;   Return the spin period at the 'filtered'
;   duntims.
;
;   Use open CDF file if ID is given, else use date to open relavent CDF.
;
;   If 'all' is set then return spin_period and duntim at all times,
;   duntim=-1d31 for outlier times.
;
;   Read the 'DUNTIMs' - sun pulse times for a 26Hr period to avoid edge
;    effects on the day in question.
;
if not keyword_set(CDF) then CDF=0
sun_time=hd_sun_time_read(date, CDF=CDF, radius=radius)
ns=n_elements(sun_time)
d1=sun_time[ns-1]-sun_time[ns-2]
sun_time=[reform(sun_time,ns), sun_time[ns-1]+d1]
;
;  Find perigee pass times
;
rad=smooth(radius,25)
dr=rad[1:*]-rad
rperigee=where((dr le 0 and dr gt -1e-4) and $
               (dr[1:*] ge 0 and dr[1:*] le 1e-4), nr)
if nr gt 2 or nr eq 0 then begin
    message, 'Found '+strtrim(nr,2)+' perigee passes...How can this be?', $
      /cont

    rperigee=where(dr le 0 and dr[1:*] gt 0,nr)
    if nr gt 1 then begin
        d=sun_time(rperigee[1:*])-sun_time(rperigee)
        if min(d) lt 18*3600.d0 then begin
            i0=0
            i1=0
            while (i1 lt nr) do begin
                tp0=sun_time(rperigee[i0])
                tp1=tp0+18*3600.d0
                if sun_time(rperigee[i1]) lt tp1 then begin
                    if rad[rperigee[i0]] gt rad[rperigee[i1]] then begin
                        rperigee[i0]=-1
                        i0=i1
                    endif else begin
                        rperigee[i1]=-1                  
                    endelse
                endif else begin
                    i0=i1
                endelse
                i1=i1+1
            endwhile
            r=where(rperigee ne -1,nr)
            if r[0] ne 0 then begin
                rperigee=rperigee[r]
            endif else begin
                message, 'Found '+strtrim(nr,2)+$
                  ' perigee passes...using backup algorithm-How can this be?'
            endelse
        endif
    endif
endif
if nr ne 0 then begin
    tperigee=sun_time(rperigee)
    if nr eq 2 then begin
        r_not_perigee=where( sun_time lt tperigee[0]-3600 or $
                             (sun_time gt tperigee[0]+3600 and $
                              sun_time lt tperigee[1]-3600) or $
                             sun_time gt tperigee[1]+3600)
    endif else begin
        r_not_perigee=where( sun_time lt tperigee[0]-3600 or $
                             (sun_time gt tperigee[0]+3600))
    endelse
endif else begin
    sun_time_range_hr=(sun_time[n_elements(sun_time)-1]-sun_time[0])/3600.d0
    if sun_time_range_hr gt 18.0 then begin
        message, 'Sun Time Perigee-Pass calculation failed: Assuming no '+$
          'perigee passes.'
    endif
    r_not_perigee=lindgen(n_elements(sun_time))
endelse
;
;   Filter Non-perigee Sun times
;

;
;          Determine spin periods for each interval
;
sun_period0=sun_time[1:*]-sun_time
nperiods=long((sun_period0)/6.0+0.5)
sun_period=sun_period0/nperiods
;
;          Find outliers (not perigee passes) and remove them
;
rfilter=hd_filter_histogram(sun_period[r_not_perigee], binsize=0.0001, $
                            min=5, max=7, pad=0.0002, fraction=0.01, $
                            verbose=keyword_set(verbose), $
                            title='Spin Period for '+strtrim(date,2))
;
;  Smooth spin_period without taking into account filtered points.
;
wt=replicate(1.0,n_elements(sun_period))
if rfilter[0] ne -1 then wt[r_not_perigee[rfilter]]=0
sun_period=smooth(sun_period*wt,21, /edge_trunc)/smooth(wt,21, /edge_trunc)

if rfilter[0] ne -1 then sun_time[r_not_perigee[rfilter]]=-1d31
if keyword_set(all) then begin
    duntim=sun_time[0:ns-1]
    return, sun_period
endif
r=where(sun_time ne -1d31)
duntim=sun_time[r]

return, sun_period[r]
end

