function hd_sun_time_read, date, CDF=CDF, one_day_only=one_day_only, $
                           radius=radius, block_time_ssm=block_time_ssm, $
                           phase_start=phase_start
;
;   Read the 'DUNTIMs' - sun pulse times for a 26Hr period to avoid edge
;    effects on the day in question.
;
;   if r is set, read pos_gse and calculate Radius
;
;
rec_start=0
rec_count=6280
if not keyword_set(CDF) then begin
    fcal=hydra_findfile( date, /ddcal )
    cal=cdf_open( fcal)
    close=1
endif else begin
    cal=CDF
    cdf_attget, CDF, 'File Date', 0, date
    close=0
endelse

rec_count= cdf_nrec( cal, 'SUN_TIME_SSM' )

hyd_cdf_varget, cal, 'SUN_TIME_SSM', sun_time, $
  rec_start=rec_start, rec_count=rec_count
sun_time= hyd_time_ssm_bug_correct( sun_time )
hyd_cdf_varget, cal, 'POS_GSE', pos, $
  rec_start=rec_start, rec_count=rec_count
hyd_cdf_varget, cal, 'BLOCK_TIME_SSM', block_time, $
  rec_start=rec_start, rec_count=rec_count
block_time= hyd_time_ssm_bug_correct( block_time )
hyd_cdf_varget, cal, 'PHASE_START', phase_start, $
  rec_start=rec_start, rec_count=rec_count
if close eq 1 then cdf_close, cal
r=where(sun_time ne 0.d0)
sun_time=sun_time[r]
pos=pos[*,r]
block_time=block_time[r]

if not keyword_set(one_day_only) then begin
    if keyword_set(block_time_ssm) then $
      message, 'Block only for one_day_only.'

    prev_date=hyd_prev_date(date)
    fcalp=hydra_findfile( prev_date, /ddcal )
    if (fcalp ne '') then begin
        calp=cdf_open( fcalp)
        rec_count= cdf_nrec( calp, 'SUN_TIME_SSM' )

        hyd_cdf_varget, calp, 'SUN_TIME_SSM', sun_timep, $
          rec_start=rec_start, rec_count=rec_count
        sun_timep= hyd_time_ssm_bug_correct( sun_timep )
        hyd_cdf_varget, calp, 'POS_GSE', posp, $
          rec_start=rec_start, rec_count=rec_count
        cdf_close, calp
        r=where(sun_timep ne 0.d0 and sun_timep gt 23*3600.d0)
        sun_timep=sun_timep[r]
        posp=posp[*,r]
    endif else begin
        sun_timep=[-1e31]
        posp=replicate(0,3,1)
    endelse
    next_date=hyd_next_date(date)
    fcaln=hydra_findfile( next_date, /ddcal )
    if (fcaln ne '') then begin
        caln=cdf_open( fcaln)
        rec_count= cdf_nrec( caln, 'SUN_TIME_SSM' )
        hyd_cdf_varget, caln, 'SUN_TIME_SSM', sun_timen, $
          rec_start=rec_start, rec_count=rec_count
        sun_timen= hyd_time_ssm_bug_correct( sun_timen )
        hyd_cdf_varget, caln, 'POS_GSE', posn, $
          rec_start=rec_start, rec_count=rec_count
        cdf_close, caln
        r=where(sun_timen ne 0.d0 and sun_timen lt 3600.d0)
        sun_timen=sun_timen[r]
        posn=posn[*,r]
    endif else begin
        sun_timen=[-1e31]
        posn=replicate(0.0,3,1)
    endelse

    sun_time=[sun_timep-24*3600.d0, sun_time, sun_timen+24*3600.d0]
    radius=sqrt([total(posp^2,1),total(pos^2,1),total(posn^2,1)])
    r=where(radius ne 0.0, nr)
    if nr lt n_elements(radius) then begin
        sun_time=sun_time(r)
        radius=radius(r)
    endif
endif else begin
    radius=sqrt(total(pos^2,1))
    block_time_ssm=block_time
endelse    

return, sun_time
end
