function hyd_filter_angle, angle_in, use_cos=use_cos, use_sin=use_sin
;
;   Filter Angle by adding noise to remove the stair-step affect,
;   and then filter the noisy data.
;
;
verbose=0                       ; Makes a plot.
;
da0=!pi/128.
na=n_elements(angle_in)
;
;  Determine Delta for each measurement
;
angle=angle_in
da=replicate(da0,na)
np=100
if keyword_set(use_cos) then begin
    angle=cos(angle_in)
    da=abs(sin(angle_in))*da0
    np=20
endif
if keyword_set(use_sin) then begin
    angle=sin(angle_in)
    da=abs(cos(angle_in))*da0
    np=20
endif
;
;   divide into constant segments
;
rstep0=where(angle(1:*)-angle ne 0.0, nstep0)
if nstep0 ne 0 then begin
    rstep0=[-1,rstep0,na-1]

    rstep=[[rstep0(0:nstep0)+0.5],[rstep0(1:*)+0.5]]
    rmid=0.5*(rstep(*,0)+rstep(*,1))
    vstep=angle(rstep(*,0)+0.5)
    dv_r=hyd_sign([vstep(1:*)-vstep,0])
    dv_l=hyd_sign([0,-(vstep(1:*)-vstep)])
    
    x=reform(transpose([[rstep(*,0)+0.01], $
                        [rmid], $
                        [rstep(*,1)-0.01]]),3*n_elements(rmid))
    y=reform(transpose([[angle(rmid)+0.5*da*dv_l], $
                        [angle(rmid)], $
                        [angle(rmid)+0.5*da*dv_r]]),3*n_elements(rmid))
    
    angle_new=interpol(y,x,findgen(na))
endif else begin
    angle_new=angle
endelse

if keyword_set(verbose) then begin
    hydra_setcolors, cs
    plot, angle(0:np), psym=-1, /ynoz
    ;oplot, angle(0:np-1)-0.5*da
    ;oplot, angle(0:np-1)+0.5*da
    ;oplot, transpose(x), transpose(y), psym=-2

    oplot, angle_new(0:np-1), psym=1, color=cs.green
    ;oplot, angle_new(0:np-1)-0.5*da, color=cs.green
    ;oplot, angle_new(0:np-1)+0.5*da, color=cs.green

    stop
endif
angle_out=angle_new

return, angle_out
end
