FUNCTION hydra_bdata_valid, time=time, $
                            xyz=xyz, bx=bx, by=by, bz=bz, $
                            angles=angles, theta=theta, phi=phi, $
                            fill=fill
;
;     Purpose:
;        Return a valid array corresponding to time that is 1=okay,
                                ;        0=filtered
;
;     Inputs:
;        /xyz, bx, by, bz, time  -  Filter on each component for deviations.
;
;        /angles, theta, phi, time - Filter on phi looking for "flat
                                ;        spots" and on theta for deviations.
;
;        fill=fill data value
;
;     Example Calls:
;        valid=bdata_valid(time=t, bx=bx, by=by, bz=bz, /xyz, fill=1e31)
;
;        valid=dbata_valid(time=t, theta=theta, phi=phi, /angles)
;
;
;
;     Details:
;        Divide time interval into 1 minute sub-intervals and treat
                                ;        them seperately.
;        Phi/Theta Filter are different than the others.
;
;
forward_function hydra_filter_bcomp
;
;
;
;
   
   IF keyword_set(xyz) THEN BEGIN
       IF (n_elements(bx) eq 0) OR (n_elements(by) eq 0) OR $
         (n_elements(bz) eq 0) OR (n_elements(time) eq 0) THEN BEGIN
           message, 'One or more B components not available.', /cont
           return, replicate(long(1),n_elements(time))
      ENDIF 
      IF n_elements(fill) EQ 1 THEN BEGIN 
          validx = hydra_filter_bcomp(time, bx, fill=fill)
          validy = hydra_filter_bcomp(time, by, fill=fill)
          validz = hydra_filter_bcomp(time, bz, fill=fill)
      ENDIF ELSE BEGIN
          validx = hydra_filter_bcomp(time, bx)
          validy = hydra_filter_bcomp(time, by)
         validz = hydra_filter_bcomp(time, bz)
      ENDELSE 
      valid = validx AND validy AND validz
   ENDIF ELSE BEGIN
       IF (n_elements(phi) eq 0) OR (n_elements(theta) eq 0) OR $
         (n_elements(time) eq 0) THEN BEGIN
           message, 'One or more B angles not available.', /cont
           m= max( [n_elements(phi),n_elements(theta),n_elements(time)] )
           return, replicate(long(1),m)
       ENDIF 
      IF n_elements(fill) EQ 1 THEN BEGIN 
         validt = hydra_filter_bcomp(time, theta, /theta, fill=fill)
         validp = hydra_filter_bcomp(time, phi, /phi, fill=fill)
      ENDIF ELSE BEGIN 
         validt = hydra_filter_bcomp(time, theta, /theta)
         validp = hydra_filter_bcomp(time, phi, /phi)
      ENDELSE 
      valid = validt AND validp
   ENDELSE 

   return, valid
END
