FUNCTION hydra_filter_bcomp, time, comp, $
                             phi=phi, theta=theta, fill=fill
;
;     Purpose:
;        Return a valid array for the input component array based on
                                ;        changes from one point to the
                                ;        next as a function of time.
;
;     Example Calls:
;        validx=filter_bcomp(time, bx, fill=1e31)
;        validt=filter_bcomp(time, theta, /theta)
;
;
   forward_function hydra_filter_bthreshold
;
   nt = n_elements(time)
   valid = replicate(long(1), nt)

   IF n_elements(fill) EQ 1 THEN BEGIN
      r = where(comp EQ fill)
      IF r(0) NE -1 THEN valid(r) = 0
   ENDIF 

   max = max(comp, min=min)
   IF (max-min LT 7) THEN BEGIN
      message, 'Component not in counts?  Aborting filter.', /cont
      return, valid
   ENDIF 


   dt = time(1:nt-1)-time(0:nt-2)
   IF (abs((dt(1)-dt(0))/dt(0)) LT 0.1) THEN BEGIN
      dt = long(dt/dt(0)+0.5)
   ENDIF ELSE BEGIN
      message, 'dt not consistent.  Aborting B Filter.', $
       /cont
      return, valid
   ENDELSE 

   rvalid= where( valid(1:(nt-1)) eq 1 and valid(0:(nt-2)) eq 1  )
   rinvalid= where( ( valid(1:(nt-1)) eq 1 and valid(0:(nt-2)) eq 1 ) eq 0 )
   
   s = size(comp)
   ns = n_elements(s)
   IF s(ns-2) EQ 1 THEN comp1 = long(comp) ELSE comp1 = comp
   delta0 = fltarr( nt-1 )
   if (rvalid(0) ne -1) then $
     delta0(rvalid) = (comp1(1+rvalid)-comp1(rvalid))/dt(rvalid)
   if (rinvalid(0) ne -1) then  delta0(rinvalid) = 0

   IF n_elements(fill) EQ 1 THEN BEGIN
      r = where(comp EQ fill)
      IF r(0) NE -1 THEN BEGIN
         delta0(r < nt-2) = 0
         delta0(0 < r-1 < nt-2) = 0
      ENDIF 
   ENDIF 

   ntd = nt-1
   ni = 3000
   IF ntd LT ni THEN ni = ntd
   nintervals = long(ntd/ni) >  1
   nextra = ntd MOD ni

   FOR i=0,nintervals-1 DO BEGIN
      i0 = i*long(ni)
      i1 = i0+ni-1
      IF (i EQ nintervals-1) THEN i1 = i1+nextra
      n = i1-i0+1
      delta = delta0(i0:i1)

      threshold = hydra_filter_bthreshold(abs(delta))

      r = where(abs(delta) GT threshold,nr)
      IF r(0) NE -1 THEN BEGIN 
         IF keyword_set(phi) THEN BEGIN
            IF r(0) NE 0 THEN BEGIN
               r = [0,r]
               nr = nr+1
            ENDIF 
            IF r(nr-1) NE n-1 THEN BEGIN
               r = [r,n-1]
               nr = nr+1
            ENDIF 
            
            FOR j=0,nr-2 DO BEGIN 

               il = r(j)+4 < n-1
               ir = r(j+1)-1
               IF (ir-il GT 5) OR (ir-il GT 1 AND r(j) EQ 0) THEN BEGIN
                  delta1 = delta(il:ir)
                  ndelta = ir-il+1
                  delta_bar = total(delta1, /double)/ndelta
                  delta_sigma = sqrt(total((delta1-delta_bar)^2, /double)/ $
                                     (ndelta-1))
;                  print, j, i0, il, ir, 0, n-1, delta_bar, delta_sigma
                  IF (delta_sigma LT 1.0 AND abs(delta_bar) LT 0.1) THEN $
                   valid(i0+(r(j) > 0): i0+(r(j+1)+2 < n-1)) = 0
               ENDIF
            ENDFOR  

         ENDIF ELSE BEGIN
            IF keyword_set(theta) THEN BEGIN
               FOR j=0,nr-1 DO $
                valid(i0+r(j) > 0 : i0+r(j)+20 < nt-1) = 0
            ENDIF ELSE BEGIN 
               FOR j=0,nr-1 DO $
                valid(i0+r(j) > 0 : i0+r(j)+3 < nt-1) = 0
            ENDELSE 
         ENDELSE 
      ENDIF 
   ENDFOR 
   
   return, valid
END
