FUNCTION hydra_filter_bthreshold, delta

   n = n_elements(delta)
   max = long(max(delta, min=min)+0.5)
   min = 0

   done = 0
   WHILE done GE 0 DO BEGIN 

      IF (n GT 2000) THEN $
       binsize = long((max)/128+0.5) > 1 $
      ELSE $
       binsize = (done+1)*long(30*(max)/n+0.5) > 1
      yh = histogram(delta, min=0, max=max, binsize=binsize)
      nh = n_elements(yh)
      xh = (findgen(nh)-0.5)*binsize

      r = where(yh EQ 0)
      IF r(0) NE -1 THEN BEGIN 
         IF r(0) NE 0 THEN BEGIN 
            threshold = xh(r(0))
            done = -1
         ENDIF ELSE BEGIN
            done = done+1
         ENDELSE 
      ENDIF ELSE BEGIN 
         threshold = xh(nh-1)+1
         done = -1
      ENDELSE
   ENDWHILE 
   return, threshold
END
