function array_list, array, index, add=add
;
;  Manage a structure of arrays as a kind of linked-list
;
;  Format:   
;             array.index
;             array.value
;
;
if keyword_set(add) then begin
    if not keyword_set(array) then begin
        n=n_elements(add)
        array={ $
                index:[0,n], $
                value:add}
    endif else begin
        n=n_elements(add)
        ni=n_elements(array.index)
        na=n_elements(array.value)
        array={ $
                index:[array.index(0:ni-2),na,array.index(ni-1)+n], $
                value:[array.value, add]}
    endelse
    return, array
endif else begin
    return, array.value(array.index(index):array.index(index+1)-1)
endelse
end
