function basename, files, directory=dir, suffix=suffix
;+
; NAME:
;
;      basename
;
; PURPOSE:
;
;      Returns the filenames with directory stripped-off.
;      Returns directory if requested.
;
;      Removes given suffix.
;
; CATEGORY:
;
;      File Utility
;
; CALLING SEQUENCE:
;
;      filename=basename(full_path_to_file, dir=out_dir, suffix=suff)
; 
; INPUTS:
;
;      files: String Array of path+filenames
;
; OPTIONAL INPUTS:
;
;
;	
; KEYWORD PARAMETERS:
;
;     suffix: String suffix to remove.
;     directory: variable to contain file's directory.
;
; OUTPUTS:
;
;     Return value
;
; OPTIONAL OUTPUTS:
;
;
;
; COMMON BLOCKS:
;
;     None
;
; SIDE EFFECTS:
;
;     None
;
; RESTRICTIONS:
;
;     None
;
; PROCEDURE:
;
;
;
; EXAMPLE:
;
;     filepath='/opt/hydra/idl_common/basename.pro'
;     filename=basename(filepath, dir=dir, suffix='.pro')
;     print, filename, dir
;
; MODIFICATION HISTORY:
;
;     Curator: rdh
;-
filenames=files
dir=files
for i=0,n_elements(files)-1 do begin
    filenames(i)=strmid(files(i),rstrpos(files(i),'/')+1)
    dir(i)=strmid(files(i),0,rstrpos(files(i),'/'))

    if keyword_set(suffix) then begin
        if size(suffix, /type) ne 7 then begin
            r=rstrpos(filenames(i),'.')
        endif else begin
            r=rstrpos(filenames(i),suffix)
            if strlen(filenames(i)) ne r+strlen(suffix) then r=-1
        endelse
        if r ne -1 then filenames(i)=strmid(filenames(i),0,r)
    endif

endfor
return, filenames
end
