function block2timetag, date_in, block, sub, nsub, $
                        ion=ion, electron=ele, $
                        time_start=time_start, time_width=time_width
;+
;
; Return the timetag of a given block and sub-block using the ion moment
; cdf file as the standard.
;
; nsub is the total number of sub-blocks involved.
;
;   Example:
;        For 2sweep electrons:
;
;            ttag=block2timetag(20010312, 2896, 2, 3, /ele)
;
;        For Block:
;
;            ttag=block2timetag(20010312, 2896, 0, 1)
;
;        Return times:
;
;            ttag=block2timetag(20010312, 2896, 2, 3, /ele, $
;                 time_start=time_start_ssm, $
;                 time_width=time_width_seconds)
;
;-
common block2timetags_common, ttags, time_bin_start, time_bin_width, $
  ion_v, date_save
date=strtrim(date_in,2)
if n_elements(date_save) eq 0 then date_save=-1
if date_save ne date then begin
    next_date=hyd_next_date(date_in)
    hyd_access, ttags, 'ion_v', ion_v, $
      get_timetags=[gen_time(     date+' 00:00'), $
                    gen_time(next_date+' 00:00')]
    hyd_access, ttags, 'time_bin_start_ssm', time_bin_start
    hyd_access, ttags, 'time_bin_width_seconds', time_bin_width
    date_save=date
endif
nsw=12.



if n_elements(ttags) gt block then begin
    ttag=ttags[block]
    time_start=time_bin_start[block]
    time_width=time_bin_width[block]
    if nsub gt 0 then begin
        extra_sweeps=0
        if keyword_set(ion) then extra_sweeps=1
        
        extra_seconds=(sub/float(nsub)+extra_sweeps/nsw)*13.8d0
        extra_ttag=extra_seconds/86400.d0
        width=13.8*(1.0/float(nsub)-1.0/nsw)
        
        ttag.bin_start=ttags[block].bin_start+extra_ttag
        ttag.bin_width=width/86400.d0
        ttag.valid_register=1
    endif
endif else begin
    ttag=ttags[0]
    ttag.bin_start=-1e31
    ttag.valid_register=0
    time_start=-1e31
    time_width=-1e31
endelse
return, ttag
end
