PRO ASPECT_SET, xlow, ylow, aspect_ratio_in, aspect_ratio_device_in
;+
; NAME:
;       aspect_set
;
; PURPOSE:
;	Sets !P.POSITION for correct plot aspect ratio for either 
;	'PS' or 'X' devices.  Other devices not tested.
;
; CATEGORY:
;       Plotting
;
; CALLING SEQUENCE:
;       aspect_set, xlow, ylow, aspect_ratio_in, aspect_ratio_device
;
;       N.B. The fourth argument is optional.
; 
; INPUTS:
;       xlow: Amount of space to the left/right of plot frame for axes.
;       ylow: Amount of space above/below plot frame for axes.
;       aspect_ratio_in: Aspect Ratio to set.
;       aspect_ratio_device: Aspect ratio of device. (optional)
;
; OPTIONAL INPUTS:
;       None.
;
;	
; KEYWORD PARAMETERS:
;       None.
;
;
; OUTPUTS:
;       !P.POSITION for next plot
;
;
; OPTIONAL OUTPUTS:
;       None.
;
;
; COMMON BLOCKS:
;       None.
;
; SIDE EFFECTS:
;       !P.POSITION
;
; RESTRICTIONS:
;       None.
;
; PROCEDURE:
;
;       Figures out the position for the plot frame such that the aspect
;       ratio is set correctly given !P.MULTI.
;
; EXAMPLE:
;       set_plot, 'x'
;       aspect_set, 0.1, 0.1, 2.0
;       contour, z, x, y, position=!p.position
;
; MODIFICATION HISTORY:
;       $Log: aspect_set.pro,v $
;       Revision 1.2  2000/04/28 15:57:06  rdh
;       Made 4th argument optional via common block with set_page.
;
;       Revision 1.1  1998/11/16 21:16:56  rdh
;       Initial revision
;
;       Written: RDH
;-
;
;	Sets !P.POSITION for correct plot aspect ratio for either 
;	'PS' or 'X' devices
;
;	xlow, ylow are amount of space above/below or left/right 
;	of plot axes
;
COMMON device_char, xsize, ysize, aspect_ratio_device_com

if n_params() eq 3 then aspect_ratio_device=aspect_ratio_device_com $
else aspect_ratio_device=aspect_ratio_device_in

IF xlow GE 0.5 THEN BEGIN
   PRINT, 'Not enough space for plot. ' + $
		'Reduce xsp in line_plot or contour_plot. (0<xsp<0.5)'
   xlow = 0.2
ENDIF
IF ylow GE 0.5 THEN BEGIN
   PRINT, 'Not enough space for plot. ' + $
		'Reduce ysp in line_plot or contour_plot. (0<ysp<0.5)'
   ylow = 0.2
ENDIF

nplot = !p.multi(0)
nx = !p.multi(1)
ny = !p.multi(2)
if (nplot EQ 0) then begin
   nploty = ny - 1
   nplotx = 0
endif else begin
   nploty = (nplot-1)/nx
   nplotx = nx - (nplot - nploty*nx)
ENDELSE
;print, !p.multi
;print, nx, ny, nplot
;print, nplotx, nploty


asp = aspect_ratio_in/aspect_ratio_device
dx = 1.0/float(nx)
dy = 1.0/float(ny)

xlo = float(nplotx)*dx + xlow*dx
ylo = float(nploty)*dy + ylow*dy
xhi = float(nplotx+1)*dx - xlow*dx
yhi = float(nploty+1)*dy - ylow*dy

;print, 'xlo, ylo, xhi, yhi ', xlo, ylo, xhi, yhi

dx = (xhi - xlo)
dy = yhi - ylo

dl = min([dx,dy])

if (asp GE 1.0) then begin
   if (dl*asp LE dx) then begin
      deltax = dl*asp
      deltay = dl
   endif else begin
      deltax = dx
      deltay = dx/asp
   endelse
endif else begin
   if (dl/asp LE dy) then begin
      deltay = dl/asp
      deltax = dl
   endif else begin
      deltay = dy
      deltax = dy*asp
   endelse
endelse

!p.position(0) = xlo + (dx - deltax)/2.0
!p.position(1) = ylo + (dy - deltay)/2.0
!p.position(2) = xhi - (dx - deltax)/2.0
!p.position(3) = yhi - (dy - deltay)/2.0

return
end
