pro aug09_epar_jds, timetags, fstr, qstr, var
;
;  Procedure to read Jack's files and print quantities from
;
;  /home/jds/2-D_Moments/
;
;  fstr:
;       'spikes'                     spikes_hi_res_eparl_*.sav
;       'combined'                   combine_hi_res_eparl_*.sav
;
;  qstr:
;       'epar'
;       'limit'
;       'time'
;
dir='/opt/hydra/tmp_data/other_data_sets/'
case fstr of
    'spikes': begin
        restore, dir+'spikes_hi_res_eparl_8_9_00_VMV.sav'
        epar=e_spikes
        time=t_spikes
        limit=e_limit_spikes
    end
    'combined': begin
        restore, dir+'combine_hi_res_eparl_8_9_00_VMV.sav'
        epar=e_comp
        time=t_comp
        limit=e_limit_comp
    end
endcase

case qstr of
    'epar':begin
        var=epar
    end
    'limit':begin
        var=limit
    end
    'time':begin
        var=time/3600.0
    end
endcase
s=sort(time)
time=time(s)
var=float(var(s))
if dt lt 0.04 then begin
    dt=2*dt                     ; Correct for time in idlsav file
endif

hd_make_timetags, timetags, time-0.5*dt, dt, /ssm, dateyyyymmdd=19960529
hd_insert_fill, timetags, var, fixed_width=0.05/86400.d0

return
end
