PRO BLANK_PLOT, XRANGE = xrange, YRANGE = yrange
;+
; NAME:
;      BLANK_PLOT
;
;
; PURPOSE:
;
;      Make a blank plot to use for writing text information with
;      XYOUTS, or if no axes are desired.
;
; CATEGORY:
;      Plotting
;
;
; CALLING SEQUENCE:
;
;      BLANK_PLOT, XRANGE=[xlow,xhigh], YRANGE=[ylow,yhi]
; 
; INPUTS:
;      None.
;
;
; OPTIONAL INPUTS:
;      None.
;
;	
; KEYWORD PARAMETERS:
;      XRANGE: X Range of the plotting surface.
;      YRANGE: Y Range of the plotting surface.
;
; OUTPUTS:
;      A Blank Plotting Surface.
;
; OPTIONAL OUTPUTS:
;      None.
;
; COMMON BLOCKS:
;      None.
;
; SIDE EFFECTS:
;      None.
;
; RESTRICTIONS:
;      None.
;
; PROCEDURE:
;
;      Make a plot call setting no axes to be drawn.
;
; EXAMPLE:
;      BLANK_PLOT
;      XYOUTS, 0.1, 0.8, 'Message Line 1'
;      XYOUTS, 0.1, 0.5, 'Message Line 2'
;      XYOUTS, 0.1, 0.2, 'Message Line 3'
;
;
; MODIFICATION HISTORY:
;      $Log: blank_plot.pro,v $
;      Revision 1.1  1998/11/16 21:31:58  rdh
;      Initial revision
;
;      Written: RDH
;-
;
nplot = !p.multi(0)
nx = !p.multi(1)
ny = !p.multi(2)
if (nplot EQ 0) then begin
   nploty = ny - 1
   nplotx = 0
endif else begin
   nploty = (nplot-1)/ny
   nplotx = nx - (nplot - nploty*ny)
endelse

;dx = 1.0/float(nx)
;dy = 1.0/float(ny)
;xlo = float(nplotx)*dx
;ylo = float(nploty)*dy
;xhi = float(nplotx+1)*dx
;yhi = float(nploty+1)*dy
;!p.position = [xlo,ylo,xhi,yhi]

IF NOT KEYWORD_SET(xrange) THEN xrange = [0,1]
IF NOT KEYWORD_SET(yrange) THEN yrange = [0,1]
x = [xrange(0) - 1, xrange(1) + 1]
y = [yrange(0) - 1, yrange(0) - 1]
PLOT, x, y, XRANGE = xrange, YRANGE = yrange, $
   XSTYLE = 21, YSTYLE = 21

RETURN
END






