FUNCTION deficiency_string_web, cond, standard, testv, label
   IF (cond) THEN BEGIN 
      dstring = label+': '+strtrim(string(testv,format='(f6.2)'),2)+' -> '+ $
       strtrim(string(standard,format='(f6.2)'),2)
   ENDIF ELSE BEGIN
      dstring = ""
   ENDELSE 

   return, dstring
END
 

PRO calibration_version_web, footprint, cal_version, quality_string, $
                             quality_flag, verbose=verbose, mode=mode, $
                             current_footprint=current_footprint, $
                             deficiency=deficiency, $
                             use_web_file=use_web_file, echo=echo
;
;   Read calibration summary file.
;
;   INPUT:  footprint = structure with individual calibration versions
;   INPUT:  mode keyword is set to the block_mode (use if block_mode
;                is not a field in footprint) 
;
;   OUTPUT: cal_version = absolute Calibration Version
;   OUTPUT: quality_string = String Describing Calibration State
;   OUTPUT: quality_flag = .true. if it is up-to-date
;   
;   OUTPUT: current_footprint returns the most up-to-date footprint values
;   OUTPUT: deficiency returns a string stating what needs to be updated
;
;   file = '/opt/hydra/gain_data/'+filename

   filename = 'cal_version_summary_v00.dat'

   command = 'wget http://supras.physics.uiowa.edu/hydra_data/versions/'+$
       filename

   IF keyword_set(use_web_file) THEN BEGIN 

      spawn, 'cd /tmp;mkdir -p hydra'
      spawn, command+' -O /tmp/hydra/'+filename
      file = '/tmp/hydra/'+filename
      get_lun, unit
      openr, unit, file

   ENDIF ELSE BEGIN 
      spawn, command+' -O - -o log', unit=unit
   ENDELSE 

   nversions = 10
   nmodes = 50

   cal_vers1 = {cal_v1, $
               cal: float(0.0), $
               glint_mask: float(0.0), $
               potential: float(0.0), $
               mfe: float(0.0), $
               background: float(0.0), $
               relative_gains: float(0.0), $
               intersweep: float(0.0), $
               interbox_gains: float(0.0) }


   cal_vers2 = {cal_v2, $
               nversions: 0L, $
               versions: replicate(cal_vers1, nversions)}

   cal_vers = replicate(cal_vers2, nmodes)

   cal_str =  {cal_str1, $
                  cal: float(0.0), $
                  string: string("") }

   cal_string = replicate(cal_str, nversions)


   line = string("")
;
;  skip over headers
;
   readf, unit, line
   IF keyword_set(echo) THEN print, line
   WHILE (strmid(line, 0, 11) NE 'END_STRINGS') DO BEGIN
      CASE strmid(line,0,4) OF
         'DDEI': BEGIN
            block_mode = (str_sep(strcompress(line),' '))(3)
;            print, block_mode
            imode = block_mode
            iversion = -1
         END
         'VERS': BEGIN
            iversion = iversion+1
            cal_vers(imode).nversions = iversion
            nums = float((str_sep(strcompress(line),' '))(1:8))
            cal_vers(imode).versions(iversion).cal = nums(0)
            cal_vers(imode).versions(iversion).glint_mask = nums(1)
            cal_vers(imode).versions(iversion).potential = nums(2)
            cal_vers(imode).versions(iversion).mfe = nums(3)
            cal_vers(imode).versions(iversion).background = nums(4)
            cal_vers(imode).versions(iversion).relative_gains = nums(5)
            cal_vers(imode).versions(iversion).intersweep = nums(6)
            cal_vers(imode).versions(iversion).interbox_gains = nums(7)
         END
         'STRI': BEGIN
            iversion = -1
         END
         'QSTR': BEGIN
            iversion = iversion + 1
            calv = (str_sep(strcompress(line),' '))(1)
            string = (str_sep(strcompress(line),'"'))(1)

            cal_string(iversion).cal = calv
            cal_string(iversion+1).cal = -1.0
            cal_string(iversion).string = string


         END
         ELSE: BEGIN
         END
      ENDCASE 
      readf, unit, line
      IF keyword_set(echo) THEN print, line
   ENDWHILE 
   close, unit
   free_lun, unit

   IF keyword_set(use_web_file) THEN BEGIN 
      spawn, 'rm '+file
   ENDIF 

   IF keyword_set(verbose) THEN BEGIN 
      print, 'This Day/Mode Footprint:'
      print, 'GMV:   ', footprint.glint_mask_version
      print, 'POTV:  ', footprint.sc_pot_version
      print, 'MFEV:  ', footprint.mfe_gain_version
      print, 'BACKV: ', footprint.background_version
      print, 'RGV:   ', footprint.rgains_version
      print, 'ISV:   ', footprint.intersweep_version
      print, 'IGV:   ', footprint.igains_version
      print
   ENDIF 

   glint_mask = long(footprint.glint_mask_version*100+0.01)/100.0
   IF (glint_mask EQ 4.19) THEN glint_mask = 4.2

   sc_pot = long(footprint.sc_pot_version*100+0.01)/100.0
   mfe = long(footprint.mfe_gain_version*100+0.01)/100.0
   background = long(footprint.background_version*100+0.01)/100.0
   rgains = long(footprint.rgains_version*100+0.01)/100.0
   intersweep = long(footprint.intersweep_version*100+0.01)/100.0
   igains = long(footprint.igains_version*100+0.01)/100.0


   iversion = 0

   IF keyword_set(mode) THEN imode = mode ELSE imode = footprint.block_mode
   nv = cal_vers(imode).nversions

   logical_v = (glint_mask EQ $
                cal_vers(imode).versions(iversion).glint_mask) AND  $
    (sc_pot EQ cal_vers(imode).versions(iversion).potential) AND $
    (mfe EQ cal_vers(imode).versions(iversion).mfe) AND $
    (background EQ cal_vers(imode).versions(iversion).background) AND $
    (rgains EQ cal_vers(imode).versions(iversion).relative_gains) AND $
    (intersweep EQ cal_vers(imode).versions(iversion).intersweep) AND $
    (igains EQ cal_vers(imode).versions(iversion).interbox_gains)

   WHILE ((NOT logical_v) AND (iversion LT nv)) DO BEGIN
      iversion = iversion + 1

      logical_v = (glint_mask EQ $
                   cal_vers(imode).versions(iversion).glint_mask) AND  $
       (sc_pot EQ cal_vers(imode).versions(iversion).potential) AND $
       (mfe EQ cal_vers(imode).versions(iversion).mfe) AND $
       (background EQ cal_vers(imode).versions(iversion).background) AND $
       (rgains EQ cal_vers(imode).versions(iversion).relative_gains) AND $
       (intersweep EQ cal_vers(imode).versions(iversion).intersweep) AND $
       (igains EQ cal_vers(imode).versions(iversion).interbox_gains)

   ENDWHILE 
   IF (logical_v) THEN BEGIN

      cal_version = cal_vers(imode).versions(iversion).cal
      IF (cal_version EQ cal_vers(imode).versions(0).cal) THEN BEGIN
         quality_flag = 1
      ENDIF ELSE BEGIN
         quality_flag = 0
      ENDELSE 


   ENDIF ELSE BEGIN
      cal_version = 0.00
      quality_flag = 0

   ENDELSE 

   iversion = 0
   WHILE (cal_version NE cal_string(iversion).cal) AND $
    (cal_string(iversion).cal NE -1.0) DO $
    iversion = iversion+1

   IF (cal_version EQ cal_string(iversion).cal) THEN $
    quality_string = cal_string(iversion).string $
   ELSE quality_string = "No Message"


   current_footprint = footprint
   iversion = nv

   current_footprint.glint_mask_version = $
    cal_vers(imode).versions(iversion).glint_mask
   current_footprint.sc_pot_version = $
    cal_vers(imode).versions(iversion).potential
   current_footprint.mfe_gain_version = $
    cal_vers(imode).versions(iversion).mfe
   current_footprint.background_version = $
    cal_vers(imode).versions(iversion).background
   current_footprint.rgains_version = $
    cal_vers(imode).versions(iversion).relative_gains
   current_footprint.intersweep_version = $
    cal_vers(imode).versions(iversion).intersweep
   current_footprint.igains_version = $
    cal_vers(imode).versions(iversion).interbox_gains

   l1 = current_footprint.glint_mask_version - glint_mask
   l2 = current_footprint.sc_pot_version - sc_pot
   l3 = current_footprint.mfe_gain_version - mfe
   l4 = current_footprint.background_version - background
   l5 = current_footprint.rgains_version - rgains
   l6 = current_footprint.intersweep_version - intersweep
   l7 = current_footprint.igains_version - igains

   deficiency = ""
   deficiency = deficiency + $
    deficiency_string_web((l1 NE 0), current_footprint.glint_mask_version, $
                      glint_mask, " GLINT")
   deficiency = deficiency + $
    deficiency_string_web((l2 NE 0), current_footprint.sc_pot_version, $
                      sc_pot, " POT")
   deficiency = deficiency + $
    deficiency_string_web((l3 NE 0), current_footprint.mfe_gain_version, $
                      mfe, " MFE")
   deficiency = deficiency + $
    deficiency_string_web((l4 NE 0), current_footprint.background_version, $
                      background, " BACK")
   deficiency = deficiency + $
    deficiency_string_web((l5 NE 0), current_footprint.rgains_version, $
                      rgains, " RG")
   deficiency = deficiency + $
    deficiency_string_web((l6 NE 0), current_footprint.intersweep_version, $
                      intersweep, " ISE")
   deficiency = deficiency + $
    deficiency_string_web((l7 NE 0), current_footprint.igains_version, $
                      igains, " IBG")


   return
END

