pro cdf_get_hyd_ibtrim, id, ibtrim_version, ibtrim, verbose=verbose, $
                        current=current, history=history, $
                        index=index
;
;  Returns the ibtrim values and version from a given hydra product
;  cdf file.
;
;  Reads the version out of an open existing cdf if id is set to the
;      cdf_id of the open file.
;
;  For the following id is the date:
;
;  If current is specified, it returns the current settings.
;
;  If history is specified, it returns an array of settings
;
;  index is only defined if current or history is set
;
;
if keyword_set(history) or keyword_set(current) then begin
    date=strtrim(id,2)
endif else begin
    r=cdf_inquire(id)
    nzvars=r.nzvars
    done = 0
    cdf_attget, id, 'Creation Date', 0, date
endelse
doy96=hyd_day_of_year(set_year=1996, yyyymmdd=date)
if keyword_set(verbose) then print, 'Date='+date+' doy96='+strtrim(doy96,2)

if not keyword_set(history) and not keyword_set(current) then begin
    i=1
    while done eq 0 do begin
        r=cdf_varinq(id,i, /zvariable)
        name=r.name
        if (strpos(name, 'INTERBOX_TRIM_ELE') ne -1) then begin
            if keyword_set(verbose) then $
              print, 'Variable named '+name+' found.'
            cdf_varget, id, name, ibtrim_version
            if keyword_set(verbose) then $
              print, 'IB Trim Version = ', ibtrim_version
            done=1
        endif
        i=i+1
    endwhile
    if ibtrim_version eq 0.0 then begin
        ibtrim=[1.0,1.0]
        return
    endif
endif else begin
    ibtrim_version = -1
endelse

ibtrim_filename=$
  '/opt/hydra/gain_data/interbox_trim/hyd_ib_trim_v01.cdf'
ibid=cdf_open(ibtrim_filename)
cdf_varget, ibid, 'Date', date_read, rec_start=doy96-1
if (date_read ne date) then begin
    message, 'Record for '+date+' not found in ibtrim file. '+$
      'Found '+date_read
    ibtrim_version=-1
    ibtrim=[-1,-1]
    cdf_close, ibid
    return
endif

cdf_varget, ibid, 'IB_Constant', ibtrim0, rec_start=doy96-1
if keyword_set(verbose) then help, ibtrim0

if not keyword_set(history) and not keyword_set(current) then begin
    ibtrim_index = long((ibtrim_version-floor(ibtrim_version))*100+0.01)
endif else begin

    if keyword_set(current) then begin
        cdf_varget, ibid, 'IB_index', ibtrim_index, rec_start=doy96-1
        if keyword_set(verbose) then help, ibtrim_index
        if n_elements(index) ne 0 then $
          index=ibtrim_index
        if (ibtrim_index eq 0) then $
          ibtrim_version = 0.0 else $
          ibtrim_version = 1.0+ibtrim_index*0.01
        if ibtrim_version eq 0.0 then begin
            ibtrim=[1.0,1.0]
            cdf_close, ibid
            return
        endif
    endif
endelse
cdf_close, ibid

if not keyword_set(history) then begin
    ibtrim_version = 1.0+ibtrim_index*0.01
    ibtrim = reform(ibtrim0(*,ibtrim_index-1))
    if keyword_set(verbose) then print, 'IB Trim='+strtrim(ibtrim,2)
endif else begin
    ibtrim_version=findgen(n_elements(ibtrim0)/2)*0.01+1.0
    ibtrim_version(0)=0.0
    ibtrim=ibtrim0
endelse

return
end


