pro cdf_put_hyd_ibtrim, date, ib_input, index=index, verbose=verbose, $
                        force=force
;
;   Put the new interbox trim values into the interbox trim file: 2 floats.
;   Set the index to point to the new record, or to the set value if given
;
doy96=hyd_day_of_year(set_year=1996, yyyymmdd=date)
if keyword_set(verbose) then print, 'Date='+date+' doy96='+strtrim(doy96,2)


ibtrim_filename=$
  '/opt/hydra/gain_data/interbox_trim/hyd_ib_trim_v01.cdf'
ibid=cdf_open(ibtrim_filename)
cdf_varget, ibid, 'Date', date_read, rec_start=doy96-1
if (date_read ne date) then begin
    message, 'Record for '+date+' not found in ibtrim file. '+$
      'Found '+date_read
    ibtrim_version=-1
    ibtrim=[-1,-1]
    return
endif

cdf_varget, ibid, 'IB_Constant', ibtrim0, rec_start=doy96-1
if keyword_set(verbose) then help, ibtrim0

cdf_varget, ibid, 'IB_index', ibtrim_index, rec_start=doy96-1
if keyword_set(verbose) then help, ibtrim_index

if n_elements(index) gt 0 then begin
    if (index lt ibtrim_index) or keyword_set(force) then begin
        ibtrim_index = index
    endif else begin 
        message, 'Input index not greater than current index: CDF Put aborted.'
        return
    endelse 
endif else begin
    index=ibtrim_index+1
    ibtrim_index=ibtrim_index+1
endelse
if keyword_set(verbose) then print, 'Entering data at index: ',ibtrim_index
if (index gt 0) then $
  ibtrim0(*,ibtrim_index-1) = ib_input

cdf_varput, ibid, 'IB_index', ibtrim_index, rec_start=doy96-1
cdf_varput, ibid, 'IB_Constant', ibtrim0, rec_start=doy96-1

cdf_close, ibid

return
end
