FUNCTION channeltron_efficiency, energy, detector, bias_level, $
                                 derivative=dqde, $
                                 a1=a1, a2=a2, a3=a3, a4=a4, $
                                 outa=outa, outacc=outacc
;
;  Inputs:  energy (in eV)
;           detector (1-12)
;           bias level (0-15)
;
;
;  Function returns the channeltron efficiency for a given analyzer
;  energy in eV, correcting for the pre-acceleration voltage of each
;  detector's electron channeltron at the specified bias level.
;
;  The functional form comes from a fit to a generic curve in a sjuts
;  paper.
;
;  Written: RDH 05/14/97
;
;
;
   COMMON channeltron_efficiency_common, pre_acc

   IF n_params() NE 3 THEN BEGIN
      print, 'FUNCTION channeltron_efficiency'
      print, 'Input arguments: energy(eV), detector (1-12), bias level (0-15).'
      print, 'Optional Input keywords: a1=a1, a2=a2, a3=a3, a4=a4'
      print, 'Output Keywords: outa=[a1,a2,a3,a4], outacc=pre_acceleration,'
      print, '                 derivative=dQ/dE'
      stop
   endif

   IF (size(pre_acc))(0) EQ 0 THEN $
    set_channeltron_pre_acc, pre_acc


   IF NOT keyword_set(a1) THEN a1 = 1.011
   IF NOT keyword_set(a2) THEN a2 = 7.1
   IF NOT keyword_set(a3) THEN a3 = 24.527
   IF NOT keyword_set(a4) THEN a4 = 0.246

   outa = [a1, a2, a3, a4]


   IF bias_level GE 0 THEN begin

      outacc = pre_acc(bias_level, detector-1)

      engy = energy + pre_acc(bias_level, detector-1)

   ENDIF ELSE BEGIN

      outacc = 0

      engy = energy

   ENDELSE 

   g = a1*alog10(engy/a2)/(1.0+engy/a3)^a4

   IF keyword_set(dqde) THEN BEGIN 
      numerator = (a1*((a3+engy)/a3)^(-a4))*(a3+engy-a4*engy*alog(engy/a2))
      denominator = engy*(a3+engy)*alog(10.0)
      dqde = numerator/denominator
   ENDIF 

   return, g
END
