pro check_smear, smear_index, smear_times, smear_coords, v, tstart, tend, $
                 check=check, fix=fix, xrange=xr, zrange=zr, nx=nx, ny=ny, $
                 interval=interval
;
;    Check Saved smear against input time-intervals
;
;
;
rfill=-1e31
print, 'Checking smear_coordinates...'
check=1
nv=n_elements(v)                ;                   number of input timetags
if nv ne n_elements(tstart) or nv ne n_elements(tstart) then $
  message, 'Length of tstart, tend, v inconsistent.'
;
;    Check for ranges in x and z
;
if keyword_set(xr) then begin
    xrs=[smear_coords(0,0),smear_coords(1,0)]
    if xrs(0) ne xr(0) or xrs(1) ne xr(1) then begin
        message, 'XRANGE does not match smear.', /cont
        check=0
        return
    endif
endif
if keyword_set(zr) then begin
    zrs=[smear_coords(0,1),smear_coords(1,1)]
    if zrs(0) ne zr(0) or zrs(1) ne zr(1) then begin
        message, 'ZRANGE does not match smear.', /cont
        check=0
        return
    endif
endif
;
;     Check for matrix-size
if keyword_set(nx) then begin
    if nx ne smear_index(0,0) or ny ne smear_index(1,0) then begin
        message, 'Matrix size does not match smear.', /cont
        check=0
        return
    endif
endif
;
nst=n_elements(smear_times(*,0))-1
;
;     Check for timetags
;
do_check=1
if nst eq n_elements(v) then begin
    r=where(tstart ne smear_times(1:nst,0))
    if r(0) ne -1 then begin
        do_check=1 
    endif else begin
        r=where(tend ne smear_times(1:nst,1))
        if r(0) ne -1 then do_check=1 else do_check=0
    endelse
endif
if (do_check eq 1) then begin   ; Some timetags don't match

    if keyword_set(interval) and (interval ne rfill) and $
      (nst eq n_elements(v)) then begin
        rr=where(abs(tstart(r)-smear_times(r+1,0)) gt 0.1*interval)
        if rr(0) eq -1 then begin
            smear_times(r+1,0)=tstart(r)
        endif
        rr=where(abs(tend(r)-smear_times(r+1,1)) gt 0.1*interval)
        if rr(0) eq -1 then begin
            smear_times(r+1,1)=tend(r)
        endif
    endif

    iv=0L
    n_nomatch=0L
    rst=[0]
    rvt=[0]
    for i=1L,nst do begin
        while ((tstart(iv) lt smear_times(i,0) or $
                tend(iv) lt smear_times(i,1)) and iv lt nv-1) do iv=iv+1
        if tstart(iv) eq smear_times(i,0) and $
          tend(iv) eq smear_times(i,1) then begin
            rst=[rst,i]
            rvt=[rvt,iv]
        endif else begin
            n_nomatch=n_nomatch+1
        endelse
    endfor
    nrst=n_elements(rst)
    if nrst eq 1 then begin
        message, $
          'WARNING: '+strtrim(nrst,2)+' input timetags not matched.', /cont
        check=0
        return
    endif
    nrst=nrst-1                 ;                number of timetags that match
    rst=rst(1:nrst)             ;                Timetags used from smear
    rvt=rvt(1:nrst)             ;                Timetags used from input

    if (nrst ne nv) then begin
        message, 'WARNING: some input timetags not covered.', /cont
        check=0
        return
    endif
    if nst ne nrst then begin
        message, 'NOTE: some smear timetags not used.', /cont
    endif
    smear_times=smear_times([0,rst],*)
    smear_index=smear_index([0,1,rst+1],*)
endif
r=where(v ne rfill)
tstart=tstart(r)
tend=tend(r)
v=v(r)
smear_times=smear_times([0,r+1],*)
smear_index=smear_index([0,1,r+2],*)

return
end

