pro confidence_points, x, y, z, delta, xmin, ymin, zmin, $
                       xg1, yg1, zg1, $
                       cluster_min, cluster_index, cluster_n, cluster_rchisq, $
                       status, $
                       zlevel, plot=plot, $
                       path_info=info68, xy=xy, $
                       use_contour=use_contour, $
                       xscan_range=xscan_range, yscan_range=yscan_range

;
;   Return 68% confidence points
;
;   Input:
;         x,y,z:             Scan values as irregular data
;         delta:             Nominal width of "clusters"
;         xmin, ymin, zmin:  Coordinates of Minima found
;
;   Output:
;          xg1, yg1, zg1:    A list of 68% confidence points
;          cluster_index:    Starting index to xg1 for a cluster
;          cluster_n:        Number of points (xg1) in a cluster
;                                  i0=cluster_index(i)
;                                  i1=i0+cluster_n(i)-1
;                                  xg1(i0:i1)
;          cluster_min:      Index to cluster for xmin
;          cluster_rchisq:   Minimum RChisq of a cluster:
;                                       zmin(cluster_min(i))
;
;          status:           border status 2,4,8,16 indicating scan needs
;                                    to increase in indiced directory
;                            -32 means triangulation failed
;
;
;
fill=-1e31
hyd_contour_points, z, x/1e5, y/1e5, [zlevel], /irregular, c_charsiz=1.5, $
  thick=3, /downhill, /overplot, $
  /path_data_coords, path_info=info68, path_xy=xy
if keyword_set(use_contour) then begin
    status=0
    r=where(info68.high_low eq 0,nr)
    if nr eq 0 then return
    for i=0,nr-1 do begin
        ix=info68(r(i)).offset
        in=info68(r(i)).n
        xminc=min(xy(0,ix:ix+in-1),max=xmaxc)
        yminc=min(xy(1,ix:ix+in-1),max=ymaxc)
        
        if xminc le xscan_range(0) then status=status or 2
        if xmaxc ge xscan_range(1) then status=status or 4
        if yminc le yscan_range(0) then status=status or 8
        if ymaxc ge yscan_range(1) then status=status or 16

    endfor
    return
endif
;
;   Triangulate and sample to rectangular grid and get interior points
;
GS=delta*0.2*[1,1]
limits=[min(x),min(y),max(x),max(y)]
if n_elements(uniq(x(sort(x)))) gt 1 or $
  n_elements(uniq(y(sort(y)))) gt 1 then begin
    triangulate, x,y, tr
endif else begin
    tr=-1
endelse
if tr(0) eq -1 then begin
    status=-32
    return
endif
zg=trigrid(x,y,z,tr,GS,limits, missing=999, xgrid=xg, ygrid=yg)

status=0
xg1=-1
rii=where(zmin lt zlevel,nrii)

;print, 'Number of Minima: ', nrii
if nrii gt 50 then begin
    message, 'Number of Minima gt 50: '+strtrim(nrii,2), /cont
    ;stop
endif
rbowl=where(info68.high_low eq 0, nrbowl)
cluster_min=lonarr(n_elements(xmin))-1
cluster_index=lonarr(nrbowl > 1)
cluster_n=lonarr(nrbowl > 1)
xg1=0
status=0
for ir=0,nrbowl-1 do begin
    i=rbowl(ir)
    i0=info68(i).offset
    i1=info68(i).offset+info68(i).n-1
    points=xy(*,i0:i1)
    if keyword_set(plot) then begin
        oplot, points(0,*), points(1,*), psym=4
    endif
    n_xmin=n_elements(xmin)
    tda=fltarr(n_xmin)
    xc=points(0,*)*1e5
    yc=points(1,*)*1e5
    for j=0,n_xmin-1 do begin
        inside=hyd_inside_contour(xc,yc,xmin(j), ymin(j),total_angle=ta)
        tda(j)=ta
    endfor
    min_angle_total=max(tda,i_min)

    xg_min=min(abs(xmin(i_min)-xg),ig)
    yg_min=min(abs(ymin(i_min)-yg),jg)

                                ;print, 'MIN: ', ir, i_min, xg_min, yg_min
                                ;print, delta_min

    ring, zg, ig, jg, 0, n_elements(xg)-1, 0, n_elements(yg)-1, zlevel, $
      i_interior, j_interior, nmax
    ij=where(i_interior ge 0)


    if (where((min(xg) eq xg(i_interior(ij))),nr))(0) ne -1 then $
      status=status or 2
    if (where((max(xg) eq xg(i_interior(ij))),nr))(0) ne -1 then $
      status=status or 4
    if (where((min(yg) eq yg(j_interior(ij))),nr))(0) ne -1 then $
      status=status or 8
    if (where((max(yg) eq yg(j_interior(ij))),nr))(0) ne -1 then $
      status=status or 16

    if status eq 0 then begin
        if (where(zg(i_interior(ij)-1,j_interior(ij)) eq 999))(0) ne -1 then $
          status=status or 2
        if (where(zg(i_interior(ij)+1,j_interior(ij)) eq 999))(0) ne -1 then $
          status=status or 4
        if (where(zg(i_interior(ij),j_interior(ij)-1) eq 999))(0) ne -1 then $
          status=status or 8
        if (where(zg(i_interior(ij),j_interior(ij)+1) eq 999))(0) ne -1 then $
          status=status or 16
    endif

    if keyword_set(plot) then begin
        hydra_setcolors, cs
        oplot, xg(i_interior(ij))/1e5, yg(j_interior(ij))/1e5, $
          psym=2, symsize=0.5, color=cs.green
    endif
    xc=points(0,*)*1e5
    yc=points(1,*)*1e5
    for j=0,n_elements(xmin)-1 do begin
        if hyd_inside_contour(xc,yc, xmin(j), ymin(j)) eq 0 then $
          cluster_min(j)=ir
    endfor

    n=n_elements(ij)
    if keyword_set(xg1) then $
      cluster_index(ir)=n_elements(xg1) $
    else cluster_index(ir)=0
    cluster_n(ir)=n
    
    if keyword_set(xg1) then begin
        xg1=[xg1,xg(i_interior(ij))]
        yg1=[yg1,yg(j_interior(ij))]
        zg1=[zg1,zg(i_interior(ij),j_interior(ij))]
    endif else begin
        xg1=xg(i_interior(ij))
        yg1=yg(j_interior(ij))
        zg1=zg(i_interior(ij),j_interior(ij))
    endelse
endfor
cluster_rchisq=fltarr(nrbowl > 1)

for i=0, nrbowl-1 do begin
    r=where(cluster_min eq i,nr)
    if nr eq 0 then begin
        for j=0,nr-1 do begin
            if zmin(r(j)) lt zlevel then begin
                message, 'ERROR: cluster has no minima', /cont
            endif
        endfor
        cluster_rchisq(i)=fill
    endif else begin
        cluster_rchisq(i)=min(zmin(r))
    endelse
endfor
end
