; IDL Procedure for complete control of plotting - Line Plost
PRO CONTOUR_PLOT, F, X, Y, $
                MAX_VALUE = max_value, MIN_VALUE = min_value, $
                OVERPLOT = overplot, $
                XRANGE = xrange, YRANGE = yrange, $
                XTITLE = xtitle, YTITLE = ytitle, TITLE = title, $
                CHARSIZE = charsize, $
                ASPECT_RATIO = aspect_ratio_in, $
                XSP = xsp_in, YSP = ysp_in, $
                ROUTINE_TITLE = routine_title, _EXTRA=e
;+
;
; NAME:
;      CONTOUR_PLOT
;
;
; PURPOSE:
;      Plot contours, but using a set aspect ratio.
;
; CATEGORY:
;      Plotting
;
; CALLING SEQUENCE:
;      CONTOUR_PLOT, F, X, Y, $
;                MAX_VALUE = max_value, MIN_VALUE = min_value, $
;                OVERPLOT = overplot, $
;                XRANGE = xrange, YRANGE = yrange, $
;                XTITLE = xtitle, YTITLE = ytitle, TITLE = title, $
;                CHARSIZE = charsize, $
;                ASPECT_RATIO = aspect_ratio_in, $
;                XSP = xsp_in, YSP = ysp_in, $
;                ROUTINE_TITLE = routine_title
;
; INPUTS:
;      X, Y, F(X,Y)
;
; OPTIONAL INPUTS:
;      None.
;	
; KEYWORD PARAMETERS:
;	MAX_VALUE values above this are ignored
;	MIN_VALUE values below this are ignored
;	OVERPLOT can be set to plot over existing axes
;	(X,Y)LOG specify logarithmic axes
;	(X,Y)RANGE Range to be plotted: xrange = [xlow,xhigh]
;	TITLE, (X,Y)TITLE axis titles and plot title
;	CHARSIZE character size
;	ASPECT_RATIO Ly/Lx: aspect_ratio
;	XSP fraction of surface left/right of axes
;	YSP fraction of surface above/below axes
;	ROUTINE_TITLE gives name of routine for plot label w/time (for
;	     subtitle)
;
;       Other parameters are sent to contour unaffected.
;
; OUTPUTS:
;       None.
;
;
; OPTIONAL OUTPUTS:
;       None.
;
;
; COMMON BLOCKS:
;       COMMON device_char, xsize, ysize, aspect_ratio_device
;
;
;
; SIDE EFFECTS:
;       Common Block 
;
;
; RESTRICTIONS:
;       None.
;
;
; PROCEDURE:
;       Set up !P.POSITION and then call contour for the plot.
;
;
; EXAMPLE:
;       contour_plot, f, x, y, aspect=2.0
;
;
; MODIFICATION HISTORY:
;       $Log: contour_plot.pro,v $
;       Revision 1.1  1998/11/16 21:42:23  rdh
;       Initial revision
;
;       Written: RDH
;-
COMMON device_char, xsize, ysize, aspect_ratio_device
;
;
cr = '!6'
time1 = SYSTIME(0)
IF KEYWORD_SET(ROUTINE_TITLE) THEN BEGIN
   time = cr+ROUTINE_TITLE + ': ' + strmid(time1,4,7) + strmid(time1,20,4)
ENDIF ELSE BEGIN
   time = ''
ENDELSE

if KEYWORD_SET(aspect_ratio_in) then begin
   if (!p.position(0) EQ !p.position(2)) then begin


      IF KEYWORD_SET(xsp_in) THEN xlow = xsp_in ELSE xlow = 0.2
      IF KEYWORD_SET(ysp_in) THEN ylow = ysp_in ELSE ylow = 0.2
      ASPECT_SET, xlow, ylow, aspect_ratio_in, aspect_ratio_device
;      print, !p.position
   endif else begin
      print, 'WARNING: aspect ratio not used, !P.POSITION manually set.' 
   endelse
endif

IF KEYWORD_SET(max_value) THEN max_val = max_value ELSE max_val = 1.e+31
IF KEYWORD_SET(min_value) THEN min_val = min_value ELSE min_val = -1.e+31

IF KEYWORD_SET(XRANGE) THEN XRANGE = XRANGE ELSE XRANGE = [0,0]
IF KEYWORD_SET(YRANGE) THEN YRANGE = YRANGE ELSE YRANGE = [0,0]

IF KEYWORD_SET(XTITLE) THEN XTITLE = cr+XTITLE ELSE XTITLE = ''
IF KEYWORD_SET(YTITLE) THEN YTITLE = cr+YTITLE ELSE YTITLE = ''
IF KEYWORD_SET(xtitle) THEN XTITLE = cr+xtitle
IF KEYWORD_SET(ytitle) THEN YTITLE = cr+ytitle
IF KEYWORD_SET(TITLE) THEN TITLE = cr+TITLE ELSE TITLE = ''

IF KEYWORD_SET(charsize) THEN charsize = charsize ELSE charsize = 1.0



IF KEYWORD_SET(overplot) THEN BEGIN
   CONTOUR, F,X,Y, /OVERPLOT, $
      MAX_VALUE = max_val, MIN_VALUE = min_val, $
      _EXTRA=e
ENDIF ELSE BEGIN
   CONTOUR, F,X,Y, XTITLE = XTITLE, YTITLE = YTITLE, TITLE = TITLE, $
      XRANGE = xrange, YRANGE = yrange, $
      SUBTITLE = time, $
      CHARSIZE = CHARSIZE, $
      MAX_VALUE = max_val, MIN_VALUE = min_val, $
      _EXTRA=e
ENDELSE

!p.position = [0.0,0.0,0.0,0.0]


RETURN
END










