function decimate_smear, coords, mid=mid, footprint=footprint
;
;   Decimate Smear based on weight (total sampling time) in a bin
;
;   Input:
;          coords:    Coordinates output from average_smear.
;
;   Keyword Inputs:
;          mid:       The point above which the probability of plot is 100%.
;
;   Return value:
;          coords:    Filtered coordinates in the same form.
;
;   Output:
;          footprint: Appends footprint message for hydra_id.
;
xx=coords(*,0)
yy=coords(*,1)
zz=coords(*,2)
ww=coords(*,4)
if not keyword_set(mid) then mid=max(ww)/2.0
rw=mid*randomu(seed,n_elements(ww))
rr=where(ww ge rw)

footprint0='Decimate_smear: mid='+strtrim(mid,2)
if keyword_set(footprint) then footprint=[footprint,footprint0]

return, coords(rr,*)
end
