PRO END_OF_PAGE, PRINT = print, LPR=printer, delete=delete, slow=slow
   COMMON print_file, filename, prev_device, present_device
   COMMON gif_colors, fore_color, back_color
   COMMON page_numbers, page
;
;	No required Keywords.
;
;	Defines end of program or output file
;	PRINT prints plot file immediately if desired
;	Resets device to what it was before set_ps ran
;
;	Paired calls to set_ps/end_of_prog can be used to print some pages 
;	and not others
;

   if (!D.NAME EQ 'X') then return

   if keyword_set(slow) then $
     print_command='print_slowly -c ' else print_command='lp -c '

   IF (!D.NAME EQ 'PS' OR !D.NAME EQ 'PCL') THEN BEGIN
      IF (!D.NAME EQ 'PCL') THEN BEGIN
         print, 'Printing w/PCL'
         printer = 'cis_color'
      ENDIF 
      DEVICE, /CLOSE_FILE
      file=basename(filename, dir=dir)
      if dir eq '' then dir='.'
      if keyword_set(page) then begin
          filename0 = dir+'/'+'pg_'+$
            strtrim(string(page,format='(i4.4)'),2)+'_'+file
      endif else begin
          spawn, 'echo $$', pid
          filename0 = dir+'/'+'pg_'+strtrim(pid(0),2)+'_'+file
      endelse
      command0 = 'mv '+filename+' '+filename0
      SPAWN, command0
      IF KEYWORD_SET(print)  and !version.os_family eq 'unix' THEN BEGIN
         IF KEYWORD_SET(printer) THEN begin
             command = print_command + '-d '+printer+' '+filename0
         endif ELSE begin
             command = print_command + filename0
         endelse
;         message, 'SPawning: '+command, /cont
         SPAWN, command
;         message, 'Back from SPawn', /cont
      ENDIF
      DEVICE, FILENAME = filename

   ENDIF else if (!d.name eq 'Z' AND $
                  strlowcase(present_device) EQ 'gif') then begin

       write_gif, filename, tvrd()
       file=basename(filename, dir=dir)
       if dir eq '' then dir='.'
       if keyword_set(page) then begin
           filename0=dir+strmid(file,0,rstrpos(filename,'.'))+$
             '_'+strtrim(string(page,format='(i4.4)'),2)+$
             strmid(file,rstrpos(filename,'.'),strlen(file))
       endif else begin
           spawn, 'echo $$', pid
           filename0 = dir+'/'+'pg_'+strtrim(pid(0),2)+'_'+filename
       endelse
       command0 = 'mv '+filename+' '+filename0
       SPAWN, command0

       IF (NOT keyword_set(noreset)) THEN BEGIN
           !p.color = fore_color
           !p.background = back_color
       ENDIF 
       IF KEYWORD_SET(print)  and !version.os_family eq 'unix' THEN BEGIN
           rnd = strtrim(abs(randomn(seed)),2)
           file = '/tmp/'+filename0+'_'+rnd
           command = 'printgif '+file+'> /dev/null; rm '+$
             file+' &'
           SPAWN, 'cp '+filename+' '+file
           WAIT, 5
           SPAWN, command
           print, 'Executing: printgif '+filename0
       ENDIF


   endif

   !P.MULTI(0) = 0

   IF keyword_set(print) AND keyword_set(delete) $
      and !version.os_family eq 'unix' THEN BEGIN
       spawn, 'rm -f '+filename0
   ENDIF
   if keyword_set(page) then page=page+1

   RETURN
END






