;+
; NAME: 
;      END_OF_PROG
;
; PURPOSE:
;      To define the end of the program so that output cleanup can be 
;      performed such as closing postscript files, sending files to
;      printer, etc.
;
; CATEGORY:
;      Program Utility
;
; CALLING SEQUENCE:
;      END_OF_PROG, PRINT = print, LPR=printer, NORESET=noreset, DELETE=delete,
;                   COLOR=color
; INPUTS:
;      All are keywords.
;
; OPTIONAL INPUTS:
;      All keywords.
;	
; KEYWORD PARAMETERS:
;      PRINT = print: If non-zero, sends output to the printer.
;      LPR = printer: Sets the printer to use. (Default is $printer).
;      NORESET = noreset: If non-zero the device is NOT reset to its
;                         value before call to SET_PS.
;      DELETE = delete: If non-zero the output file is deleted. 
;                      (use with print)
;      COLOR = color: Tells the system to print to the color printer
;                     for postscript.
;      PRIORITY = lp-priority: 0: default, 39 is lowest.
;
; OUTPUTS:
;      None explicit. 
;
; OPTIONAL OUTPUTS:
;      None.
;
; COMMON BLOCKS:
;      Uses PRINT_FILE common for communication with set_ps, set_pcl, set_gif.
;      Uses GIF_COLORS common with set_gif.
;
; SIDE EFFECTS:
;      Can change device, delete output files.
;
; RESTRICTIONS:
;      Should be use with set_ps, set_gif, set_pcl.
;
; PROCEDURE:
;      Closes output file if PS, PCL, being used.  Creates gif if Z.
;      Sends output to printer if desired.
;      Deletes output file if requested.
;      Resets device unless NORESET set.
;
; EXAMPLE:
;      SET_PS, /LANDSCAPE
;      plot, [0,1], [2,4], psym=-1, title='Example'
;      END_OF_PROG, /PRINT, /DELETE, lpr = 'ggs_laser'
;      This redirects postscript output to ggs_laser.
;
; MODIFICATION HISTORY:
;      None yet.
;-
PRO END_OF_PROG, PRINT = print, LPR=printer, noreset=noreset, delete=delete, $
                 color=color, nosave=nosave, priority=priority
   COMMON print_file, filename, prev_device, present_device
   COMMON gif_colors, fore_color, back_color
   COMMON page_numbers, page
;
;	No required Keywords.
;
;	Defines end of program or output file
;	PRINT prints plot file immediately if desired
;	Resets device to what it was before set_ps ran
;
;	Paired calls to set_ps/end_of_prog can be used to print some pages 
;	and not others
;
   if keyword_set(nosave) then begin
       IF (!D.NAME EQ 'Z' AND strlowcase(present_device) EQ 'gif') THEN BEGIN
           IF (NOT keyword_set(noreset)) THEN BEGIN
               !p.color = fore_color
               !p.background = back_color
           ENDIF
       endif
       IF (NOT keyword_set(noreset)) THEN SET_PLOT, prev_device
       return
   endif

   file=basename(filename, dir=dir)
   if keyword_set(page) then begin
       filename0 = dir+'/'+'pg_'+$
         strtrim(string(page,format='(i4.4)'),2)+'_'+file
   endif else begin
       filename0 = filename
   endelse

   if (not keyword_set(priority)) and (getenv('USER') eq 'hqs') then begin
       priority=10
   endif

   if not keyword_set(priority) then priority=0
   priority=' -q '+strtrim(priority,2)+' '

   IF (!D.NAME EQ 'PS') THEN BEGIN
      DEVICE, /CLOSE_FILE
      IF KEYWORD_SET(printer) THEN $
       command = 'lp -c -d '+printer+priority+filename0 $
      ELSE $
       IF keyword_set(color) THEN $
       command = 'printps ' + filename0 ELSE $
        command = 'lp -c '+priority+filename0
      IF KEYWORD_SET(print) THEN BEGIN
         SPAWN, command
         print, 'Executing: '+command
      ENDIF
      IF (NOT keyword_set(noreset)) THEN SET_PLOT, prev_device
   ENDIF ELSE BEGIN
      IF (!D.NAME EQ 'PCL') THEN BEGIN
         DEVICE, /CLOSE_FILE
         command = 'lp -c -d cis_color'+priority+ filename0
         IF KEYWORD_SET(print) THEN BEGIN
            SPAWN, command
            print, 'Executing: '+command
         ENDIF
         IF (NOT keyword_set(noreset)) THEN SET_PLOT, prev_device
      ENDIF ELSE BEGIN
         IF (keyword_set(present_device)) THEN BEGIN 
            IF (!D.NAME EQ 'Z' AND strlowcase(present_device) EQ 'gif') $
             THEN BEGIN
               write_gif, filename0, tvrd()
               IF (NOT keyword_set(noreset)) THEN BEGIN
                  !p.color = fore_color
                  !p.background = back_color
               ENDIF 
               IF KEYWORD_SET(print) THEN BEGIN
                  rnd = strtrim(abs(randomn(seed)),2)
                  file = '/tmp/'+filename0+'_'+rnd
                  command = 'printgif '+file+'> /dev/null; rm '+$
                   file+' &'
                  SPAWN, 'cp '+filename0+' '+file
                  WAIT, 5
                  SPAWN, command
                  print, 'Executing: printgif '+filename0
               ENDIF
            ENDIF
            IF (NOT keyword_set(noreset)) THEN SET_PLOT, prev_device
         ENDIF 
      ENDELSE 
   ENDELSE 

   IF keyword_set(print) AND keyword_set(delete) THEN $
    spawn, 'rm -f '+filename0

   RETURN
END
