pro expand_points, x, y, z, w, dx, dy, n
;
;   Expand points z(x,y) by a factor of n (for given dx,dy) 
;          according to their weight w (normalized to 1).
;
xi=x
yi=y
zi=z
wi=w
dxi=dx
dyi=dy

xm=[findgen(n)]
ym=[replicate(0,n)]
for i=1,n-1 do begin
    xm=[xm,replicate(i,n)]
    ym=[ym,replicate(i,n)]
endfor
xm=(xm-0.5*(n-1))*dxi
ym=(ym-0.5*(n-1))*dyi
wm=replicate(wi(0),n,n)
zm=replicate(zi(0),n,n)
rm=randomu(seed,n,n)
r=where(wm ge rm)
if r(0) eq -1 then r=[(n*n)/2]
x=xi(0)+xm(r)
y=yi(0)+ym(r)
z=zm(r)
w=wm(r)
for i=1L,n_elements(xi)-1 do begin
    wm=replicate(wi(i),n,n)
    zm=replicate(zi(i),n,n)
    rm=randomu(seed,n,n)
    r=where(wm ge rm)
    if r(0) ne -1 then begin
        x=[x,xi(i)+xm(r)]
        y=[y,yi(i)+ym(r)]
        z=[z,zm(r)]
        w=[w,wm(r)]
    endif
endfor

return
end
