function find_border_points, x, y, bx_in, by_in, nind, plot=plot
;
;   Return the indices to border points from the set x, y.
;
;   bx_in, by_in are the odered set of border points.
;
;
;  Complete Border Lines
;
bx=[bx_in,bx_in[0]]
by=[by_in,by_in[0]]
dbx=bx[1:*]-bx
dby=by[1:*]-by

if keyword_set(plot) then begin
    hydra_setcolors, cs
endif
fuzz=0.01*((max(bx,min=min)-min) > (max(by,min=min)-min))
fuzz_sq=fuzz^2

index=replicate(0,n_elements(x))
;
;   Find Equations of Lines
;
m=fltarr(n_elements(dbx))
b=fltarr(n_elements(dbx))
aa=fltarr(n_elements(dbx))
bb=fltarr(n_elements(dbx))
cc=fltarr(n_elements(dbx))

r=where(dbx ne 0., nr)
if nr gt 0 then begin
    m[r]=dby(r)/dbx(r)
    b[r]=by[r]+m[r]*(-bx[r])

    aa[r]=-m[r]
    bb[r]=1.0
    cc[r]=-b[r]
endif
r0=where(dbx eq 0., nr0)
if nr0 gt 0 then begin
    aa[r0]=1.0
    bb[r0]=0.0
    cc[r0]=-bx[r0]
endif
;
;  Equations of Lines AAx+BBy+CC=0 now ready
;
for i=0,n_elements(x)-1 do begin
    if keyword_set(plot) then begin
        oplot, [x[i]],[y[i]], psym=1, color=cs.cyan
    endif
    r=where(abs((x[i]-bx)^2+(y[i]-by)^2) lt fuzz_sq)
    if r[0] ne -1 then begin
        index[i]=1 
    endif else begin
        dd=abs((aa*x[i]+bb*y[i]+cc)/sqrt(aa^2+bb^2))
        min=min(dd, idd)
        if min lt fuzz then begin ; Is on a line, on line-segment?
            d1sq=(x[i]-bx)^2+(y[i]-by)^2
            d2sq=(x[i]-bx[1:*])^2+(y[i]-by[1:*])^2
            dsq=(bx[1:*]-bx)^2+(by[1:*]-by)^2
            r=where(dsq gt d1sq and dsq gt d2sq, nr)
            if nr ne -1 then index[i]=1
        endif
    endelse
    if keyword_set(plot) then begin
        if index[i] eq 1 then begin
            oplot, [x[i]],[y[i]], psym=4, color=cs.cyan
        endif 
;        wait, 1
    endif
endfor
ind=where(index eq 1,n)
if n_params() eq 5 then nind=n

return, ind
end
